: /bin/sh script
#set -xv
# -----------------------------------------------------------------------------
# UNARCH.FETCH moves unarchived files from the user's .unarchive directories
#              to his target directory. (Called by unarchive.)
# -----------------------------------------------------------------------------
targetdir=$HOME
targetfiles=$targetdir/targetfiles

# ------------------------------------------------------------
# See if user wants another target directory besides $HOME. If
# so, set targetdir to that directory.
# ------------------------------------------------------------ 
arguments="$*"

for i in $arguments
do
    if [ "$i" != '-F' ]
    then
	targetdir=$HOME/$i
    fi
done

# --------------------------------------------------------------------------
# Test to see if there are files to be retrieved. If there are, make a list
# of them and test to see if files by the same name exist in $targetdir.  If
# there are duplicates, prompt the user to rename the file in $targetdir
# before moving the unarchived file there.
# --------------------------------------------------------------------------

cd $targetdir
ls > $targetfiles
cd $HOME
if [ -d .unarchive ]
then
    cd $HOME/.unarchive
    ls > directories
    while read directory
    do
	cd $HOME/.unarchive/$directory
	ls > fetchfiles
	while read fetchfile
	do
	    if grep $fetchfile $targetfiles
	    then
		echo "\n\nYou have unarchived a file named $fetchfile."
		echo "\n There is a file in $targetdir"
		echo "\n named $fetchfile.  Do you want to overlay"
		echo "\n it with your unarchived file?\n"
		answer=`(read A; echo $A)</dev/tty`
		case $answer in
		    " "|y|Y)
			mv $fetchfile $targetdir
			echo "\n\n$fetchfile was retrieved.\n"
			sleep 3
			;;
		    n|N)
			echo "Please enter new filename for the file.  "
			newname=`(read B; echo $B)</dev/tty`
			mv $targetdir/$fetchfile $targetdir/$newname
			mv $fetchfile $targetdir
			echo "\n $fetchfile was retrieved.\n"
			sleep 3
			;;
		esac
	    else
		mv $fetchfile $targetdir
	    fi
	done < fetchfiles
    done < directories
else
    echo "\n\n There are no files that have been unarchived for you.\n"
fi
#------------------------------
#  Clean up.
# -----------------------------

cd $HOME
rm -r .unarchive
rm targetfiles
rm $targetdir/fetchfiles

