: /bin/sh script
#set -x
# ----------------------------------------------------------------
# UNARCH.TAPE: This program extracts files from tape that users
#              have requested. It puts these unarchived files in
#              the users' .unarchive directories and sends a 
#              message to them telling them that their files have
#              been retrieved.
# ----------------------------------------------------------------
#   Initialize internal program variables: 
# ----------------------------------------------------------------

msgfile=$ADMDIR/unarch.msg
ret=/tmp/unarch.ret
skip=/tmp/unarch.skips
tmp=/tmp/unarch.tmp
vols=/tmp/unarch.volids
passwd2=/tmp/passwd2

export msgfile ret skip tmp vols passwd2

# ----------------------------------------------------------------
#	Unarchive each tape:
# ----------------------------------------------------------------

cd $UNARDIR	;# /tmp hardwired so we can work in the unarchive dir
while read volid
do
    echo "Mount volid $volid.  Enter \"r\" when ready.\n (Enter \"n\" to skip to the next tape.)\n\n\n\n\n\n"
    answer=`(read A; echo $A) </dev/tty`
    case $answer in
    r|R)
#  sed -e "s:/:tar xv  :" </tmp/$volid > $tmp    			#%BSD4%
#  sed -e "s:^[^/]*/\(.*\):tar xvf /dev/rmt0 \1 :"</tmp/$volid >$tmp    #%XENIX%
#  sed -e "s:^[^/]*/\(.*\):tar xv /dev/rmt/c0d0h \1 :"</tmp/$volid >$tmp #%SYSV%
	mv $tmp /tmp/$volid
        chmod 744 /tmp/$volid
        /tmp/$volid
        rm /tmp/$volid
	done="$done $volid"
        continue
        ;;
    *)
	for i in $done
	do
	    grep -v $i $vols >$tmp
	    mv $tmp $vols
	done
	echo "\"r\" must be entered to continue program."
	echo "\"n\" must be entered to skip to next tape."
	echo "Reenter \"unarch.tape\" to begin again.\n\n\n\n\n\n"
	exit 2
	;;
    esac
done <$vols

# ----------------------------------------------------------------
#	Get list of files unarchived and their respective dates:
# ----------------------------------------------------------------

awk '{print $2"  " $3}' $UNARFILE >$ret

# -------------------------------------------------------------------------
#	Isolate users' login ids and home directories.
#       Make a .unarchive directory under $HOME if needed.
#       Move their unarchived files to that directory.
#       Send a message to the user telling him his files are unarchived.
# -------------------------------------------------------------------------

while read login
do
    grep "^$login:" /etc/passwd >> $passwd2
done < $LOGFILE
cat $passwd2 |
sed "s/^\([^:]*\):.*:\([^:]*\):[^:]*$/\1   \2/" |
while read loginid home
do
    export loginid home
    grep $loginid $ret > $UNARDIR/move
    if [ -s $UNARDIR/move ]
    then   
	echo $loginid >> $UNARRET          # Make list of login dirs unarchived 
 	    if [ ! -d $home/.unarchive ]   # Make .unarchive directory under
 	    then			   # user's $HOME if there is none.
	        mkdir $home/.unarchive
		chmod 755 $home/.unarchive
	    fi
        while read dte filepath
        do
	    dirdate=`echo $dte | $TOOLDIR/ymd`  # Convert to yymmdd format
            if [ ! -d $home/.unarchive/$dirdate ] # Make dirs under user's
            then			          # $HOME/.unarchive directory &
	        mkdir $home/.unarchive/$dirdate   # name these by date.
	        chmod 755 $home/.unarchive/$dirdate
            fi
        done < $UNARDIR/move
	$ETCDIR/mv.files
        rm $UNARFILE* $UNARDIR/move* $UNARDIR/temp* $UNARDIR/del_dirs
        mail $loginid -s 'Unarchived Files' < $msgfile
    fi
done


# ----------------------------------------------------------------
#	Clean up:
# ----------------------------------------------------------------

cat /dev/null >$UNARFILE
cat /dev/null >$LOGFILE
rm $ret $vols $passwd2

# ----------------------------------------------------------------
