#ifndef lint
    static char RCSid[] = "@(#)$Header: tb.sup.c,v 1.1 $";
#endif

/*
 * Function inventory for Toolbox Support module:
 *
 *	main (int argc, char *argv[])
 *	ArchConv (char *File, (BOOLEAN) int IsOld)
 *	ChgLine (char *line, (BOOLEAN) int IsOld)
 *	ChgDate (char *DateStr)
 *	GetToday (char DateStr[])
 *      char *CnvToDMY (char DateStr[])
 *      char *CnvToYMD (char DateOut[])
 *	char *CnvMonth (char MonStr[])
 *	IsDMY (char *DateStr)
 *	error (char *Format, char *arg)
 */


#ifdef BSD4X
#  include <sys/time.h>
#else
#  include <time.h>
#endif /* BSD4X */


#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <errno.h>

/*
 * The following defines smooth over some OS incompatibilities.
 */
#ifndef BSD4X
#define vfork	fork
#define index	strchr
#define rindex	strrchr
#endif

/*
 * Defines of read, write, execute, and existence for access()
 */
#define R_OK	4	/* Test for Read permission */
#define W_OK	2	/* Test for Write permission */
#define X_OK	1	/* Test for eXecute (search) permission */
#define F_OK	0	/* Test for existence of File */

/*
 * The following two defines make string comparison less cryptic.
 */
#define strequ(a, b)		(strcmp((a), (b)) == 0)
#define strnequ(a, b, n)	(strncmp((a), (b), (n)) == 0)

/*
 * Mnemonic defines for true and false conditions.
 */
#define TRUE	1
#define FALSE	0

char    *progname;	/* program name for error message */

extern char    *index (),
	       *rindex (),
	       *strcat (),
	       *strcpy ();

extern int errno;

char           *CnvMonth (),
	       *CnvToYMD (),
	       *CnvToDMY ();


main (argc, argv)
int argc;
char *argv[];
{
    register int count;
    int DoingFile;
    char Date[256];
    char *File;


    DoingFile = FALSE;

    if (progname = rindex (argv[0], '/'))
	progname++;
    else
	progname = argv[0];

    if (progname[0] == 't')	/* program called as today */
    {
	GetToday (Date);
	printf ("%s\n", Date);
	exit (0);
    }

    if (argc < 2)
	gets (Date);
    else if (strequ ("-f", argv[1]))
    {
	if (argc > 2)
	{
	    File = argv[2];
	    DoingFile = TRUE;
	}
	else
	    error ("no file for -f option", "");
    }
    else if (argc > 2)
	error ("too many arguments", "");
    else
	(void) strcpy (Date, argv[1]);

    if (DoingFile)
    {
	if (progname[0] == 'y')	/* program called as ymd */
	    count = ArchConv (File, TRUE);
	else if (progname[0] == 'd')	/* program called as dmy */
	    ArchConv (File, FALSE);
	fprintf (stderr, "%s: %d lines in the file %s were converted\n",
		progname,
		count,
		Date
	);
    }
    else
    {
	if (progname[0] == 'y')	/* program called as ymd */
	{
	    if (IsDMY (Date))
		CnvToYMD (Date);
	}
	else if (progname[0] == 'd')	/* program called as dmy */
	{
	    if (!IsDMY (Date))
		CnvToDMY (Date);
	}
	else 			/* program called as cnvdate */
	    ChgDate (Date);
	printf ("%s\n", Date);
    }

    exit (0);
}


/*----------------------------------------------------------------------
 *
 * ArchConv - Convert archtable to new date format
 * 
 */

ArchConv (File, IsOld)
char *File;
int IsOld; 	/* TRUE if file is in old format */
{
    register int count;
    char    line[BUFSIZ];
    char    TmpFile[32];
    char    Cmd[64];
    FILE   *Infp,
	   *Outfp,
	   *fopen ();

    count = 0;
    if ((Infp = fopen (File, "r")) != NULL)
    {

     /* Create temp file */
	strcpy (TmpFile, "/tmp/conv.XXXXXX");
	mktemp (TmpFile);
	if ((Outfp = fopen (TmpFile, "w")) == NULL)
	    error ("Can't create temporary file %s\n", TmpFile);

	while (fgets (line, sizeof line, Infp) != NULL)
	{
	    ChgLine (line, IsOld);
	    fputs (line, Outfp);
	    count++;
	}
	fclose (Infp);
	fclose (Outfp);
    }
    else
	error ("Unable to read file %s", File);

    /* Replace original file with temporary file */
    errno = 0;
    if (unlink (File) == -1 && errno != ENOENT)
	perror ("unlink1");
    errno = 0;
    if (link (TmpFile, File) == -1)
    {
	/* If files are on different devices, copy */
	if (errno == EXDEV)
	{
	    sprintf (Cmd, "/bin/cp %s %s", TmpFile, File);
	    system (Cmd);
	}
	else
	    perror ("link");
    }
    errno = 0;
    if (unlink (TmpFile) == -1)
	perror ("unlink2");

    return (count);
}
/* end ArchTape */
 

/*----------------------------------------------------------------------
 *
 * ChgLine - Scan un/archive record for name and date to put in *uap.
 */

ChgLine (line, IsOld)
char   *line;
int IsOld;	/* TRUE if file is in old format */
{
    char    tape[16],
	    retain[16],
	    date[16],
	    file[256];

    if (sscanf (line, "%s %s %s %s", tape, retain, date, file) < 4)
	return;

    if (IsOld)
    {
	if (IsDMY (date))
	    CnvToYMD (date);
    }
    else
    {
	if (!IsDMY)
	    CnvToDMY (date);
    }

    /* REWRITE TO USE TAB SEPARATORS FOR FIELDS */
    sprintf (line, "%s %s %s %s\n", tape, retain, date, file);
    return;
}
/* end ChgLine */


/*----------------------------------------------------------------------
 *
 * ChgDate - Check if YMD or DMY and send date to proper conversion
 */

ChgDate (DateStr)
char *DateStr;
{
    if (IsDMY (DateStr))
	CnvToYMD (DateStr);
    else
	CnvToDMY (DateStr);
    return;
}


/*----------------------------------------------------------------------
 *
 * GetToday - Stick current date into the passed string.
 */

GetToday (DateStr)
char    DateStr[];
{
    long    time ();
    char   *ctime ();
    long    clock;
    char   *DatePtr;

 /* Get the current date string */
    clock = time ((long *) 0);
    DatePtr = ctime (&clock);

 /* Get 2 digit day */
    DateStr[0] = *(DatePtr + 8);
    DateStr[1] = *(DatePtr + 9);
    if (DateStr[0] == ' ')
	DateStr[0] = '0';
 
 /* Get 3 letter month */
    DateStr[3] = *(DatePtr + 4);
    DateStr[4] = *(DatePtr + 5);
    DateStr[5] = *(DatePtr + 6);

 /* Get 2 digit year */
    DateStr[7] = *(DatePtr + 22);
    DateStr[8] = *(DatePtr + 23);

 /* Format rest of string */
    DateStr[2] = DateStr[6] = ' ';
    DateStr[9] = '\0';

 /* Convert standard DMY format to YMD format */
    CnvToYMD (DateStr);

    return (TRUE);
}
/* end GetToday */


/*----------------------------------------------------------------------
 *
 * CnvToDMY - Convert date from YYMMDD format to DD Mon YY.
 */

char *CnvToDMY (DateStr)
char    DateStr[];
{
    char    MonStr[4];

 /* Move 2 digit year first */
    DateStr[7] = DateStr[0];
    DateStr[8] = DateStr[1];
    DateStr[9] = '\0';

 /* Move 2 digit day next */
    DateStr[0] = DateStr[4];
    DateStr[1] = DateStr[5];
    if (DateStr[0] == '0')
	DateStr[0] = ' ';

 /* Get alpha month last */
    MonStr[0] = DateStr[2];
    MonStr[1] = DateStr[3];
    MonStr[2] = '\0';
    CnvMonth (MonStr);
    DateStr[3] = MonStr[0];
    DateStr[4] = MonStr[1];
    DateStr[5] = MonStr[2];

 /* Add spacing */	/* REWRITE LATER TO USE SPACES HERE */
    DateStr[2] = DateStr[6] = '-';

    return (DateStr);
}
/* end CnvToDMY */


/*----------------------------------------------------------------------
 *
 * CnvToYMD - Convert date from DD Mon YY to YYMMDD format.
 */

char *CnvToYMD (DateOut)
char    DateOut[];
{
    char    DateIn[16];
    char    MonStr[4];


    if (isdigit (DateOut[1]))
	/* 2 digit day */
	strcpy (DateIn, DateOut);
    else
    {
	/* 1 digit day */
	strcpy (DateIn + 1, DateOut);
	DateIn[0] = '0';
    }

 /* Get 2 digit month first */
    MonStr[0] = DateIn[3];
    MonStr[1] = DateIn[4];
    MonStr[2] = DateIn[5];
    MonStr[3] = '\0';

    CnvMonth (MonStr);
    DateOut[2] = MonStr[0];
    DateOut[3] = MonStr[1];

 /* Get 2 digit day next */
    DateOut[4] = DateIn[0];
    DateOut[5] = DateIn[1];

 /* Get 2 digit year last */
    if (strlen (DateIn) > 9)
    {
	DateOut[0] = DateIn[9];
	DateOut[1] = DateIn[10];
    }
    else
    {
	DateOut[0] = DateIn[7];
	DateOut[1] = DateIn[8];
    }

    DateOut[6] = '\0';

    return (DateOut);
}
/* end CnvToYMD */


/*----------------------------------------------------------------------
 *
 * CnvMonth - Convert month from alpha to numeric or numeric to alpha.
 */

char *CnvMonth (MonStr)
char    MonStr[];
{
    register int     i;
    static char   *Months[] =
    {
	"Jan", "Feb", "Mar", "Apr", "May", "Jun",
	"Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
    };

    static char   *months[] =
    {
	"jan", "feb", "mar", "apr", "may", "jun",
	"jul", "aug", "sep", "oct", "nov", "dec"
    };

 /* Are we converting numbers? */
    i = atoi (MonStr);
    if (i > 0 && i < 13)
	strcpy (MonStr, Months[--i]);
    else
    {
     /* Find which month was entered */
	for (i = 0; i < 12; i++)
	    if (strequ (MonStr, Months[i]))
		break;
	    else if (strequ (MonStr, months[i]))
		break;

     /* Convert the month to a number */
	sprintf (MonStr, "%02d", ++i);
    }

    return (MonStr);
}
/* end CnvMonth */


/*----------------------------------------------------------------------
 *
 * IsDMY - Check if string is in DD-MMM-YYYY format 
 */

IsDMY ( Date)
char *Date;
{
    if (!isdigit (Date[2]) && Date[6] != '\0')
	return (TRUE);
    else
	return (FALSE);
}


/*----------------------------------------------------------------------
 *
 * error - Prints error message and exits
 */

error (format, arg)
char *format;
char *arg;
{
    char ErrStr[256];

    sprintf (ErrStr, "%s:  %s\n", progname, format);
    printf (ErrStr, arg);
    exit (3);
}
