: /bin/sh script
#set -xv
# ----------------------------------------------------------------
# ARCHLIST:  This program displays the filenames of archived files
#	     for a specific user. It may be called by archive or
#            unarchive commands.  It may also be called at the
#            shell. The -v option produces a verbose listing.
# ----------------------------------------------------------------
#       ARCHDEFS: 
#	Initialize standard archive variables:
# ----------------------------------------------------------------

ADMDIR=/usr/adm         # Directory for archive administrative files.

ETCDIR=/etc		# Directory where most system programs reside.

TOOLDIR=/usr/tools	# Directory where most user-executed programs
			# reside.

UNARDIR=/unarchive      # Directory where unarchived files are placed.
                        # Must be rw by the world.

# ----------------------------------------------------------------
#	Standard archive system files:  (These should NOT change.)
# ----------------------------------------------------------------

ARTABLE=$ADMDIR/archtable  # Database of archived files in the format:
                           # volid <sp> archive-date <sp> absolute-archive-path

ARTAPES=$ADMDIR/archive.tapes   # List of scratch tapes for archiving.

UNARFILE=$UNARDIR/,to.do        # List of files requested by users to be
				# unarchived. Must be rw by the # world. 
				# (using commas so first in # ls listing)

UNARRET=$UNARDIR/,done          # List of files that were retrieved from
				# tape by the unarchive process.

LOGFILE=$UNARDIR/login_names    # List of logon ids that will be used in
				# the unarchive process.

export ADMDIR ETCDIR TOOLDIR UNARDIR ARTABLE ARTAPES UNARFILE UNARRET LOGFILE

# ----------------------------------------------------------------
#	Initialize internal program variables:
# ----------------------------------------------------------------

longlist=/tmp/longlist
args="$*"

export args

# ----------------------------------------------------------------
#	Get login name of user:
# ----------------------------------------------------------------

case $LOGNAME in
"")
    case $USER in
    "")
	LOGNAME=`basename $HOME`
	;;
    *)
	LOGNAME=$USER
	;;
    esac
    ;;
esac

# ----------------------------------------------------------------
#	Get a list of the files archived on tape:
# ----------------------------------------------------------------

grep $LOGNAME $ARTABLE |
grep -v ' X[^ ]* ' > $longlist

# ----------------------------------------------------------------
#       Check for arguments:
# ----------------------------------------------------------------

case $# in
0)
    $TOOLDIR/short $longlist
    ;;
*)
    for i in $@
    do
        case $i in
        -v)
	    $TOOLDIR/long $longlist
	    ;;
        *)
	    echo "\narchlist: Invalid argument.\n"
	    echo "usage: archlist [ -v] \n"
	    ;;
        esac
    done

esac

# ----------------------------------------------------------------
#	Clean up:
# ----------------------------------------------------------------

rm  $longlist

# ----------------------------------------------------------------
