: /bin/sh script
#-----------------------------------------------------------------
# PROGRAM DESCRIPTION:
# UNARCHIVE simply checks to see if the user has entered arguments
#           and calls the appropriate program.
# ----------------------------------------------------------------
# ----------------------------------------------------------------
#       ARCHDEFS: 
#	Initialize standard archive variables:
# ----------------------------------------------------------------

ADMDIR=/usr/adm         # Directory for archive administrative files.

ETCDIR=/etc		# Directory where most system programs reside.

TOOLDIR=/usr/tools	# Directory where most user-executed programs
			# reside.

UNARDIR=/unarchive      # Directory where unarchived files are placed.
                        # Must be rw by the world.

# ----------------------------------------------------------------
#	Standard archive system files:  (These should NOT change.)
# ----------------------------------------------------------------

ARTABLE=$ADMDIR/archtable  # Database of archived files in the format:
                           # volid <sp> archive-date <sp> absolute-archive-path

ARTAPES=$ADMDIR/archive.tapes   # List of scratch tapes for archiving.

UNARFILE=$UNARDIR/,to.do        # List of files requested by users to be
				# unarchived. Must be rw by the # world. 
				# (using commas so first in # ls listing)

UNARRET=$UNARDIR/,done          # List of files that were retrieved from
				# tape by the unarchive process.

LOGFILE=$UNARDIR/login_names    # List of logon ids that will be used in
				# the unarchive process.

export ADMDIR ETCDIR TOOLDIR UNARDIR ARTABLE ARTAPES UNARFILE UNARRET LOGFILE

# ----------------------------------------------------------------

arguments="$*"
export arguments

#-----------------------------------------------------------------

cd $HOME
case $# in
0)			       #-----------------------------------------------
   $TOOLDIR/unarch.list        # If there are no arguments, list the files that
    ;;			       # the user has under his .unarchive directory.
*)			       #-----------------------------------------------
    for i in $@
    do
	#----------------------------------------------------------------------
	# Handle the arguments as follows:
	# ?        -> List the files that the user has archived.
	# -F       -> Fetch the files from .unarchive directories as directed.
	# filename -> Request that the file be retrieved from the archives.
	#----------------------------------------------------------------------
	case $i in
	?)
		echo "\n\n The following are files currently archived."
		$TOOLDIR/archlist
		;;
	-F)
		$TOOLDIR/unarch.get $arguments
		exit 0
		;;
	*)
		$TOOLDIR/unarch.rqst $arguments
		exit 0
		;;
	esac
    done
esac
