.TH UNARCHIVE 1
.UC
.SH NAME
unarchive \-unarchives files from tape
.SH SYNOPSIS
.B unarchive
[-F [directory]] [?] [file...]
.SH DESCRIPTION
.I file 
-The name of the file to be unarchived.
.sp
.I directory 
- The directory receiving unarchived files.
.LP
.I Unarchive
performs a number of functions
depending upon the options
the user includes.
.LP
.BR \OPTION:" "-F[directory] 
.sp
Unarchive simply moves the file or
files stored under the .unarchive
directories which are located under
the user's login directory. If
there is a file in the user's login
directory with the same name as 
an unarchived file, the user will
be prompted as follows:
.LP
.IP "" .5i                                               
You have unarchived a file named <file>
.br
There is a file in <receiving directory>
named <file>.
.br
Do you want to overlay
it with your unarchived file?
.P
.LP
If the user answers 'y' the unarchived
file will replace the existing file.
If the user answers 'n' he will receive
another message
.LP
.RS 5 
"Please enter new filename 
for the file."
.RE
.LP
The unarchived file will be moved
to the user's $HOME directory under
its original name and the other
file will be renamed.
.LP
.BR \OPTION:" "? 
.sp
Unarchive will call /usr/tools/archlist
which will simply display the names of
the files that the user currently has
archived.
.LP                                                         
.BR \OPTION:" "file... 
.sp
Unarchive with filename(s) as
arguments places the filename(s)
that the user wants unarchived
into the "/unarchive/.to.do" file.           
This in effect, requests the system
administrator to retrieve files that
have been archived to tape.  The /unarchive
directory is periodically checked for such
unarchive requests, and if one exists, the
system administrator is notified of such
a request by mail.
.LP                                                      
The files will be unarchived by the system
administrator and placed in subdirectories
created under the user's .unarchive directory.
These subdirectories are named by the date
that the user first archived the file. The
format for subdirectory names is yymmdd.
For example, if a user decides to unarchive
a file called 'junk' that was archived
on January 2, 1987, the file will be moved
to a directory $HOME/.unarchive/870102/junk
when it is retrieved from tape.
When the actual unarchive process is
completed, the user will be sent a message
by mail notifying him/her that these file(s)
have been unarchived and how to retrieve
them.
.SH FILES
/usr/tools/archlist
.br
/usr/tools/unarch.get
.br
/usr/tools/unarch.rqst
.br
/usr/adm/archtable
.br
/unarchive/login_names
.br
/unarchive/,to.do
.SH SEE ALSO
archive(1)
.SH DIAGNOSTICS
Should be self-explanatory.

