: /bin/sh script
#set -xv
#-----------------------------------------------------------------
# PROGRAM DESCRIPTION:
# UNARCH.REQUEST notifies the system of files that a user wants
#                to have unarchived. (Called by unarchive)
# ----------------------------------------------------------------
#	Initialize internal program variables:
# ----------------------------------------------------------------

LOGNAME=`basename $HOME`
tmp1=$HOME/tmpunarch1
tmp2=$HOME/tmpunarch2
requests=/tmp/,r
login=/tmp/,l

# -------------------------------------------------------------------------
# If the file is not archived, simply move it to $HOME. If the file cannot 
# be located in the archtable, a file by that name has not been archived. 
# If the file has been archived and is located in the archtable record this
# in the /unarchive directory.
# -------------------------------------------------------------------------
arguments="$*"

du -a $HOME/.archive > $tmp1

for i in $arguments
do
    grep $i $tmp1 > $tmp2
    if [ -s $tmp2 ]
    then
	while read num filepath
	do
	    if [ -f filepath ]
	    then
		dte=`echo $filepath | sed 's:^/.*/.archive/\([^/]*\)/.*$:\1:'`
		echo "Is $filepath dated $dte the file you want? (Y/N) \n"
		answer=`(read A; echo $A) </dev/tty`
		case $answer in
		""|[yY]*)
		    cp $filepath .  #Copy so still gets put to tape
		    ;;
		n|N)
		    continue
		    ;;
		esac
	    fi
	done< $tmp2
    fi
done

# -------------------------------------------------------------------
# If the file has been archived, search for the specified file and  
# ask the user if this is the file(s) he wants to be unarchived.
# If the file is not found in this search, it has not been archived.
# -------------------------------------------------------------------

grep $LOGNAME $ARTABLE > $tmp1
for i in $arguments
do
    grep $i $tmp1 > $tmp2
    if [ -s $tmp2 ]
    then
        while read num ret dte filepath
        do
	    echo "Is $filepath dated $dte the file you want? (Y/N) \n"
	    answer=`(read A; echo $A) </dev/tty`
	    case $answer in
	    ""|[yY]*)
	        echo "$num $ret $dte $filepath" >>$requests$LOGNAME
	        ;;
	    n|N)
	        continue
	        ;;
	    esac
        done <$tmp2
    else
        echo "unarchive: file \"$i\" does not exist!"
    fi
done

# ------------------------------------------------------------------------
# Call unarch.log (a C program) that updates the /unarchive/login_names
# file and the /unarchive/,to.do.(login) files.  This program has a
# setuid bit that allows the user to write to the /unarchive directory.
# ------------------------------------------------------------------------

if [ -s $requests$LOGNAME ]
then
    $TOOLDIR/unarch.log $LOGNAME -f $requests$LOGNAME
fi

# ----------------
#  Clean Up
# ----------------

rm $tmp1 $tmp2 $login$LOGNAME $requests$LOGNAME
# ----------------------------------------------------------------
