: /bin/sh script
# ----------------------------------------------------------------
# PROGRAM DESCRIPTION:
#     UNARCHIVE.CHECK: This program should be called once a day by crontab
#     to do a check on /unarchive/unarch.to.do file. If there are files listed
#     in this file, a message will be sent to the system administrator telling
#     him/her that there are files to be unarchived.
# ----------------------------------------------------------------
# ----------------------------------------------------------------
#       ARCHDEFS: 
#	Initialize standard archive variables:
# ----------------------------------------------------------------

ADMDIR=/usr/adm         # Directory for archive administrative files.

ETCDIR=/etc		# Directory where most system programs reside.

TOOLDIR=/usr/tools	# Directory where most user-executed programs
			# reside.

UNARDIR=/unarchive      # Directory where unarchived files are placed.
                        # Must be rw by the world.

# ----------------------------------------------------------------
#	Standard archive system files:  (These should NOT change.)
# ----------------------------------------------------------------

ARTABLE=$ADMDIR/archtable  # Database of archived files in the format:
                           # volid <sp> archive-date <sp> absolute-archive-path

ARTAPES=$ADMDIR/archive.tapes   # List of scratch tapes for archiving.

UNARFILE=$UNARDIR/,to.do        # List of files requested by users to be
				# unarchived. Must be rw-r--r--.
				# (using commas so first in # ls listing)

UNARRET=$UNARDIR/,done          # List of files that were retrieved from
				# tape by the unarchive process.

LOGFILE=$UNARDIR/login_names    # List of logon ids that will be used in
				# the unarchive process.

export ADMDIR ETCDIR TOOLDIR UNARDIR ARTABLE ARTAPES UNARFILE UNARRET LOGFILE

# ---------------------------------------------------------------------------
#          Initialize internal program variables:
# ---------------------------------------------------------------------------

# Local system administrator who will run the unarchive program.

    sysadm=`cat /usr/adm/system.admin`

# Message sent to system administrator notifying him/her of files to be
# unarchived.

    notice=/usr/adm/unarchive.note

# ---------------------------------------------------------------------------
if [ -s $UNARFILE* ]
then
    mail $sysadm -s 'Files to be Unarchived' < $notice
fi
