: /bin/sh script
#set -xv
# ----------------------------------------------------------------
# SHORTLIST: This program displays the filenames of archived files
#	     for a specific user. It is called by /usr/tools/archlist
#            if the user has not given any arguments.
# ----------------------------------------------------------------

list=$HOME/archlist

( cat $1; ls $HOME/.archive/*/* | grep -v 'not found' ) |
sed "s:^.*.archive/\(.*\)$: \1 :" |
sed "s:^.*/\(.*\)$: \1 :" >$list

# ----------------------------------------------------------------
#	Print list in columns or tell user there aren't any:
# ----------------------------------------------------------------

if [ -s $list ]
then
    sort $list
    pr -t -4 -l1 $list
else
    echo "archlist:  no files archived" 1>&2
fi

rm -f $list

# ----------------------------------------------------------------
