: /bin/sh script
# ------------------------------------------------------------------------
# CHECK.DISK: This program should be called by the crontab file once a
#             day to find the total amount of disk space used up by
#	      files stored under $HOME/.archive directories. When this
#	      reaches 10 megabytes, the system administrator is sent
#	      a message that a archive needs to be done.
# ------------------------------------------------------------------------

accumfile=/tmp/accumfile
archnote=/usr/adm/archnote
sysadm=`cat /usr/adm/sysadm`
totalfile=/tmp/total

	# ------------------------------------------------
	# Get the number of kilobytes used for each
	# .archive account and store these numbers
	# in /tmp/accumfile
	# ------------------------------------------------

cd /
cat /etc/passwd |
sed "s/^\([^:]*\):.*:\([^:]*\):[^:]*$/\1  \2/" |
while read loginid home
do
    if [ -d $home/.archive ]
    then
	du -s $home/.archive >> $accumfile
    fi
done

	# -------------------------------------------------
	# Add these numbers in accumfile and compare the
	# sum to see if a message should be sent to the
	# system administrator.
	# -------------------------------------------------

disk_use=0
while read number directory
    test "$?" -eq "0"
do
    disk_use=`expr $number + $disk_use`
    echo $disk_use > $totalfile
done< $accumfile
 
disk_use=`cat $totalfile`

if [ "$disk_use" -ge "5000" ]
then
	mail $sysadm -s 'Need to Archive' < $archnote
fi

# ----------------------------------------
#        Clean Up
# ----------------------------------------

rm $totalfile $accumfile
