: /bin/sh script
# ----------------------------------------------------------------
# PROGRAM DESCRIPTION:
#   ARCHIVE simply moves files to the user's .archive directory.
#   All .archive directories are archived by the system
#   administrators.
# ----------------------------------------------------------------
# ----------------------------------------------------------------
#       ARCHDEFS: 
#	Initialize standard archive variables:
# ----------------------------------------------------------------

ADMDIR=/usr/adm         # Directory for archive administrative files.

ETCDIR=/etc		# Directory where most system programs reside.

TOOLDIR=/usr/tools	# Directory where most user-executed programs
			# reside.

UNARDIR=/unarchive      # Directory where unarchived files are placed.
                        # Must be rw by the world.

# ----------------------------------------------------------------
#	Standard archive system files:  (These should NOT change.)
# ----------------------------------------------------------------

ARTABLE=$ADMDIR/archtable  # Database of archived files in the format:
                           # volid <sp> archive-date <sp> absolute-archive-path

ARTAPES=$ADMDIR/archive.tapes   # List of scratch tapes for archiving.

UNARFILE=$UNARDIR/,to.do        # List of files requested by users to be
				# unarchived. Must be rw by the # world. 
				# (using commas so first in # ls listing)

UNARRET=$UNARDIR/,done          # List of files that were retrieved from
				# tape by the unarchive process.

LOGFILE=$UNARDIR/login_names    # List of logon ids that will be used in
				# the unarchive process.

export ADMDIR ETCDIR TOOLDIR UNARDIR ARTABLE ARTAPES UNARFILE UNARRET LOGFILE
# ---------------------------------------------------------------

args=$*

# ---------------------------------------------------------------
# Capture the date and format it as yymmdd so it can be used to
# make subdirectories under .archive. This format is needed for
# sorting purposes.
# ----------------------------------------------------------------

day=`$TOOLDIR/today`

# ----------------------------------------------------------------
#    Check for arguments:
# ----------------------------------------------------------------
case $# in
0)
    echo "usage:  archive filenames ..." 1>&2
    exit 2
    ;;
esac

# ----------------------------------------------------------------
#    Ensure there is a .archive dir:
# ----------------------------------------------------------------

if [ ! -d $HOME/.archive ]
then
    mkdir $HOME/.archive
    chmod 755 $HOME/.archive
fi

if [ ! -d $HOME/.archive/$day ]
then
    mkdir $HOME/.archive/$day
    chmod 755 $HOME/.archive/$day
fi

# -----------------------------------------------------------------
# First check to see if the user typed in the name of an existing
# file. If not, tell the user that the file does not exist.
# -----------------------------------------------------------------

for i in $args
do
	if [ "$i" = '?' ]
	then
	    echo "The following are files currently archived:\n\n"
	    /usr/tools/archlist

	elif [ ! -f $i ]
	then
	    echo "archive: file \"$i\" does not exist !"

	elif [ -d $i ]
	then
	    echo "archive:  \"$i\" is a directory!\nArchiving directories is not implemented yet."

    #------------------------------------------------------------------
    # Check to see if another file by the same name is in the user's
    # .archive directory. If there is, ask the user whether he intends
    # to overlay it or rename one of the files.
    # -----------------------------------------------------------------

	elif [ -s $HOME/.archive/$day/$i ]
	then
	    echo "archive: You have already requested that $i be archived "
	    echo "         today.  Do you want to replace your previous "
	    echo "         archive request with the current $i? <y/n>"
	    answer=`(read A; echo $A) < /dev/tty`
	    case $answer in
	    y|Y|"")      #accept <CR> for yes
		    mv $i $HOME/.archive/$day
		    ;;
	    n|N)
		    echo "archive: Please enter new filename for \"$i\":  "
		    read newname
		    mv $i $HOME/.archive/$day/$newname
		    ;;
	    esac
	else
# ---------------------------------------------------------------
# If there is an existing file that is not already in the user's
# .archive directory, move the named file to $HOME/.archive
# ---------------------------------------------------------------
		mv $i $HOME/.archive/$day
	fi
done

# ----------------------------------------------------------------
