/**********************************************************************/
/* ARCHEXPIRE: This program changes the retention to expired for the  */
/*             filenames passed to it.                                */
/**********************************************************************/

#include <stdio.h>
#include <errno.h>

/* CHANGE THIS IF ARCH TABLE ELSEWHERE !!! */
#define ARTABLE  "/usr/adm/archtable"

#ifdef UCB
#    define SAFE_PATH	"PATH=/bin:/usr/bin:/usr/ucb"
#else
#    ifdef PLX
#        define SAFE_PATH	"PATH=/bin:/usr/bin:/usr/plx"
#    else
#        define SAFE_PATH	"PATH=/bin:/usr/bin"
#    endif
#endif

/*
 * The following two defines make string comparison less cryptic.
 */
#define strequ(a, b)		(strcmp((a), (b)) == 0)
#define strnequ(a, b, n)	(strncmp((a), (b), (n)) == 0)

/*
 * Mnemonic defines for true and false conditions.
 */
#define TRUE	1
#define FALSE	0

extern char **environ;
extern int errno;

main (argc,argv)
     int argc;
     char *argv[];
{
    register int i;
    char   *tmpfile,
	   *mktemp();
    char    pat [100];
    char    Cmd [256];

    if (!SecureMe ())
	exit (3);

    if (argc > 1)
    {
	tmpfile = mktemp ("/usr/tmp/archx.XXXXXX");
	for (i = 1; i < argc; i++)
	{
	    /* Backslash the pathname for sed */
	    backslash (pat, argv[i]);

	    /* Place X for expire in retention field */
	    sprintf (Cmd, "/bin/sed '/%s/s/^\\([^ ]* *\\)\\([^ ]*\\)/\\1X\\2/' %s >%s",
			    pat,
			    ARTABLE,
			    tmpfile);
	    system(Cmd);

	    /* Replace archtable with temporary file */
	    errno = 0;
	    if (unlink (ARTABLE) == -1 && errno != ENOENT)
		perror ("unlink1");
	    errno = 0;
	    if (link (tmpfile, ARTABLE) == -1)
	    {
		/* If files are on different devices, copy */
		if (errno == EXDEV)
		{
		    sprintf (Cmd, "/bin/cp %s %s", tmpfile, ARTABLE);
		    system (Cmd);
		}
		else
		    perror ("link");
	    }
	    errno = 0;
	    if (unlink (tmpfile) == -1)
		perror ("unlink2");
	}
    }
    exit (0);
}


/******************************************************************
 * Copy in string (is) to out string (os) backslashing all slashes.
 *
 */

backslash (os, is)
register char   *os,
		*is;
{
    while (*is)
    {
	if (*is == '/')
	    *os++ = '\\';
	*os++ = *is++;
    }
    *os = '\0';
}
/* End backslash () */


/*****************************************************************
 * SecureMe--Secure the environment for setuid program.
 *
 */

SecureMe ()
{
    char *p,
	 *getenv ();
    char **ep;

    umask (022);

    if ((p = getenv ("IFS")) != NULL)
	*p = '\0';
    for (ep = environ; *ep; ep++)
	if (strnequ (*ep, "PATH=", 5))
	    *ep = SAFE_PATH;
    return (TRUE);
}
/* End SecureMe () */
