: /bin/sh script
#----------------------------------------------------------------
# arch.nite: This program uses files piped through sed to isolate
#            users' login ids and their home directories. It  
#            searches each user's home directory for files to
#            be archived, and finally tars these files to tape.
# ----------------------------------------------------------------
# ----------------------------------------------------------------
#       ARCHDEFS: 
#	Initialize standard archive variables:
# ----------------------------------------------------------------

ADMDIR=/usr/adm         # Directory for archive administrative files.

ETCDIR=/etc		# Directory where most system programs reside.

TOOLDIR=/usr/tools	# Directory where most user-executed programs
			# reside.

UNARDIR=/unarchive      # Directory where unarchived files are placed.
                        # Must be rw by the world.

# ----------------------------------------------------------------
#	Standard archive system files:  (These should NOT change.)
# ----------------------------------------------------------------

ARTABLE=$ADMDIR/archtable  # Database of archived files in the format:
                           # volid <sp> archive-date <sp> absolute-archive-path

ARTAPES=$ADMDIR/archive.tapes   # List of scratch tapes for archiving.

UNARFILE=$UNARDIR/,to.do        # List of files requested by users to be
				# unarchived. Must be rw by the # world. 
				# (using commas so first in # ls listing)

UNARRET=$UNARDIR/,done          # List of files that were retrieved from
				# tape by the unarchive process.

LOGFILE=$UNARDIR/login_names    # List of logon ids that will be used in
				# the unarchive process.

export ADMDIR ETCDIR TOOLDIR UNARDIR ARTABLE ARTAPES UNARFILE UNARRET LOGFILE

# ----------------------------------------------------------------
#	Initialize internal program variables:
# ----------------------------------------------------------------

TEMPDIR=/tmp
dirs=/tmp/arch.dirs
tmp=/tmp/arch.tmp	
# ----------------------------------------------------------------

if [ -s $ARTAPES ]
then
    # ----------------------------------------------------- 
    # FOR USERS WITH /USR/ADM/ARCHIVE.TAPE FILE:
    # Get tape volid and update tape list:
    # -----------------------------------------------------

    echo "\nLIST OF AVAILABLE ARCHIVE SCRATCH TAPES:\n"
    cat $ARTAPES
    echo "\n\n\n\n\n\nMOUNT AN ARCHIVE SCRATCH TAPE,"
    while : volid is not correct
    do
	echo "\nTHEN ENTER VOLID:\n\n\n\n\n\n"
	read volid
	echo "IS $volid CORRECT? (Y/N)\n\n\n\n\n\n"
	read answer
	case $answer in
	""|y|Y)		# accept <CR> for yes
	    break
	    ;;
       '?')		# give a list of scratch tapes
	    echo "\nSELECT A TAPE FROM THE FOLLOWING LIST AND MOUNT IT,\n"
	    cat $ARTAPES
	esac
    done
    sed -e "s/$volid//" <$ARTAPES >$tmp && mv $tmp $ARTAPES #%BSD4%

else
    # ----------------------------------------------------------------
    # FOR USERS WITHOUT AN /USR/ADM/ARCHIVE.TAPE FILE:
    # Get tape volid :
    # ----------------------------------------------------------------

    echo "\n\nPLEASE MOUNT A BLANK TAPE AND ASSIGN IT A UNIQUE"
    echo "VOLID NUMBER.  REMEMBER THAT YOU CANNOT RE-USE OLD ARCHIVE TAPES"
    echo "OR YOU WILL LOSE ALL DATA PREVIOUSLY COPIED ON THEM. \n\n\n"    
    while  : volid not correct					
    do							
	echo "\nPLEASE TYPE IN THE VOLID YOU ASSIGNED TO THIS TAPE.\n"
	read volid
	echo "IS $volid CORRECT? <Y/N>\n\n\n\n"
	read answer
	case $answer in
	""|y|Y)
	       break
	       ;;	
	esac
    done	
    echo "\n\nARCHIVING IS NOW IN PROGRESS."
fi

# -----------------------------------------------------------------------------
# Isolate users login ids and home directories.
# Search each $HOME for files to be archived and update /usr/adm/archtable.
# Archive each file in $HOME/.archive. 
# -----------------------------------------------------------------------------
cd /                          
cat /etc/passwd |
sed "s/^\([^:]*\):.*:\([^:]*\):[^:]*$/\1   \2/" | 
while read loginid home
do
  if [ -d $home/.archive ]
  then
      echo $home/.archive |
      sed "s:/::" >>$dirs
      du -a $home/.archive/* |
      while read num path
      do
	  if [ ! -d $path ]
	  then
	      echo $path >> $TEMPDIR/tmp.1
	  fi
      done
      cat $TEMPDIR/tmp.1 |
##---------------------------------------------------------------------
## FOR BSD4			                                         #%BSD4%

#     sed "s:^[^/]*\(.*\.archive/\([^/]*\).*\)$:$volid N \2  \1:"> tmp.2 #%BSD4%
##---------------------------------------------------------------------
## FOR XENIX OR SYSTEM V MACHINES			    #%XENIX%
## FOR XENIX OR SYSTEM V MACHINES			    #%SYSV%

#   sed "s:^[^/]*\(/.*\)$:\1:" > $TEMPDIR/tmp.2	            #%XENIX%
#   sed "s:^[^/]*\(/.*\)$:\1:" > $TEMPDIR/tmp.2	            #%SYSV%
#   cat $TEMPDIR/tmp.2 |				    #%XENIX%
#   cat $TEMPDIR/tmp.2 |				    #%SYSV%
#   sed "s:^/.*\.archive/\([^/]*\).*$:\1:" > $TEMPDIR/tmp.3 #%XENIX%
#   sed "s:^/.*\.archive/\([^/]*\).*$:\1:" > $TEMPDIR/tmp.3 #%SYSV%
#   paste -d" " $TEMPDIR/tmp.3 $TEMPDIR/tmp.2 > $TEMPDIR/tmp.4    #%XENIX%
#   paste -d" " $TEMPDIR/tmp.3 $TEMPDIR/tmp.2 > $TEMPDIR/tmp.4    #%SYSV%
#   cat $TEMPDIR/tmp.4 |				    #%XENIX%
#   cat $TEMPDIR/tmp.4 |				    #%SYSV%
#   sed "s:^\(.*\)$:$volid N \1:"> $tmp		            #%XENIX%
#   sed "s:^\(.*\)$:$volid N \1:"> $tmp		            #%SYSV%
##----------------------------------------------------------------------
  fi
done
#tar cvf /dev/nrmt0 `cat $dirs`		     #%BSD4%
#tar cvbf 60 /dev/rmt0 `cat $dirs`           #%XENIX%
#tar cv /dev/rmt/c0d0h `cat $dirs`           #%SYSV%
cat $tmp >> $ARTABLE   

# ----------------------------------------------------------------
#	Clean up:
# ----------------------------------------------------------------

rm -r $TEMPDIR/tmp* $tmp `cat $dirs`
echo "\nARCHIVING IS COMPLETE\n\n\n\n\n\n"

# ----------------------------------------------------------------
