
/*  @(#)abcd.h 1.2 89/01/08
 *
 *  Definitions used by abcd, the automatic backup copy daemon.
 *
 *  Copyright (c) Rich Burridge.
 *                Sun Microsystems Australia - All rights reserved.
 * 
 *  Permission is given to distribute these sources, as long as the
 *  copyright messages are not removed, and no monies are exchanged.
 *
 *  No responsibility is taken for any error in accuracies inherent
 *  either to the comments or the code of this program, but if
 *  reported to me then an attempt will be made to fix them.
 */

#define  CLOSE       (void) close     /* To make lint happy. */
#define  CLOSEDIR    (void) closedir
#define  FPRINTF     (void) fprintf
#define  SPRINTF     (void) sprintf
#define  SIGNAL      (void) signal
#define  STAT        (void) stat
#define  STRCAT      (void) strcat
#define  STRCPY      (void) strcpy

#define  DIRECTORY   S_IFDIR          /* Type of files being monitored. */
#define  REGULAR     S_IFREG

#define  DOTS(A)     (A[0] == '.' && (A[1] == 0 || (A[1] == '.' && A[2] == 0)))
#define  EQUAL(a,b)  !strcmp(a,b)     /* Test for string equality. */
#define  INC         argc-- ; argv++ ;
#define  MAXFILES    5                /* Max no of files to copy in one go. */
#define  MAXLINE     MAXNAMLEN+1      /* Maximum length of path names. */


struct dinfo         /* Info record for directories being monitored. */
         {
           struct dinfo *next ;
           char d_name[MAXLINE] ;
         } ;

struct finfo         /* Information record for monitored files. */
         {
           struct finfo *next ;
           struct dirent *dirent ;
           time_t mtime ;
          } ;
