#ifndef lint
static char sccsid[] = "@(#)abcd.c 1.4 89/04/10" ;
#endif

/*  This is an automatic backup copy daemon, which copies files from one
 *  filestore area to another using either cp or rcp. Note the second
 *  filestore area could be on another machine if the file system is NFS
 *  mounted.
 *
 *  This means that the backup disk should have an identical copy of the
 *  filestore being monitored, give or take a little bit.
 *
 *  Copyright (c) Rich Burridge.
 *                Sun Microsystems Australia - All rights reserved.
 *
 *  Permission is given to distribute these sources, as long as the
 *  copyright messages are not removed, and no monies are exchanged.
 *
 *  No responsibility is taken for any error in accuracies inherent
 *  either to the comments or the code of this program, but if
 *  reported to me then an attempt will be made to fix them.
 */

#include <stdio.h>

#ifdef SYSV
#include <string.h>
#include <fcntl.h>
#else  SYSV
#include <strings.h>
#include <sys/file.h>
#endif SYSV

#include <errno.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>

#ifdef SYSV
#ifdef M_XENIX
#include <sys/ndir.h>
#define  dirent    direct
#define  d_fileno  d_ino
#else  M_XENIX
#include <sys/param.h>
#include "ndir.h"
#endif M_XENIX
#include <memory.h>
#define  bcopy(s1, s2, n)  memcpy(s2, s1, n)
#else  SYSV
#include <dirent.h>
char *sprintf() ;
#endif SYSV

#include "patchlevel.h"
#include "abcd.h"

char *malloc() ;

DIR *dirp ;                      /* Stream for monitored directory. */

struct finfo *cfile ;            /* Information on current file. */
struct finfo *files  = NULL ;    /* Files being monitored. */
struct dinfo *cdir ;             /* Pointer to current directory. */
struct dinfo *dirs = NULL ;      /* Directories being monitored. */
struct stat cstat ;              /* For statistics on current file. */
struct dirent *cur ;             /* Pointer to current directory record. */

extern int errno ;               /* Standard error reply. */

char cname[MAXLINE] ;            /* Copy program to use. */
char coff[MAXLINE] ;             /* Name offset from initial start directory. */
char cp_name[MAXLINE] ;          /* Location of "cp" copy program. */
char curdir[MAXLINE] ;           /* Current directory being monitored. */
char fdir[MAXLINE] ;             /* Directory to start copying from. */
char flist[MAXFILES][MAXLINE] ;  /* Array of filenames to copy. */
char fname[MAXLINE] ;            /* Full pathname of current file. */
char pdir[MAXLINE] ;             /* Current directory for copy request. */
char progname[MAXLINE] ;         /* Name of this program. */
char rcp_name[MAXLINE] ;         /* Location of "rcp" copy program. */
char rhost[MAXLINE] ;            /* Name of remote host for use by rcp. */
char tdir[MAXLINE] ;             /* Directory to start copying to. */

int copy_found  = 0 ;            /* Whether copy done on this pass. */
int debug = 0 ;                  /* If set, status information is given. */
int delay = 300 ;                /* Sleep time for program in seconds. */
int docopy = 1 ;                 /* Rcp files right from the beginning. */
int loc = 0 ;                    /* Current location in the directory block. */
int fcnt = 0 ;                   /* No. of files to copy in current request. */
int fd ;                         /* File descriptor for various opens. */
int no_dirs = 1 ;                /* Number of directories being monitored. */
int usercp = 0 ;                 /* Backup method, cp or rcp. */


main(argc,argv)
int argc ;
char *argv[] ;
{
  STRCPY(progname, argv[0]) ;    /* Save this programs name. */
  get_options(argc,argv) ;       /* Get command line options. */
  setup() ;                      /* Initialise parameters. */
  while (1)                      /* Do it forever. */
    {
      get_next_dir() ;           /* Is there another directory? */
      while (get_next_entry())   /* Is there another file in directory? */
        {
          if (!DOTS(cur->d_name))  /* Is it the . or .. entry? */
            {
              if (no_record())     /* Is this file already monitored? */
                {
                  if ((cstat.st_mode & S_IFMT) == DIRECTORY)  /* Directory? */
                    {
                      if (make_dir_entry())
                        {
                          copy(DIRECTORY) ;
                          free((char *) cur) ;
                        }
                    }
                  else
                    {
                      make_file_entry() ;   /* Make a file entry. */
                      copy(REGULAR) ;       /* Copy it to backup machine. */
                    }
                }     
              else if (file_modified())
                {
                  copy(REGULAR) ;           /* File been modified? */
                  free((char *) cur) ;
                }
              else free((char *) cur) ;
            }
          else free((char *) cur) ;
        }
    }
}


/*  Use the portable BSD directory emulation routines if this is System V. */

#ifdef SYSV
#ifndef  M_XENIX
#include "ndir.c"
#endif   M_XENIX
#endif SYSV


char *
Malloc(n)
int n ;
{
  char *val ;

  if ((val = malloc((unsigned) n)) == NULL)
    FPRINTF(stderr,"%s: Out of memory.\n", progname) ;
  return val ;
}


copy(filetype)           /* Copy file to another directory. */
int filetype ;
{
  char name[MAXLINE] ;

  if (docopy)            /* Are we copying this time around. */
    {
      copy_found = 1 ;
      STRCPY(name, "") ;
      if (strlen(coff))
        {
          STRCAT(name, coff) ;
          STRCAT(name, "/") ;
        }
      STRCAT(name, cur->d_name) ;
      if (strcmp(curdir, pdir) != 0)  /* This directory != copy directory? */
        {
          if (fcnt) output(name, REGULAR) ;
          STRCPY(pdir, curdir) ;
        }
      if (filetype == DIRECTORY)
        {
          if (fcnt) output(name, REGULAR) ;
          output(name, DIRECTORY) ;
        }
      else if (fcnt >= MAXFILES)     /* Room in file list for this filename? */
        {
          output(name, REGULAR) ;
          STRCPY(flist[fcnt++], name) ;
        }
      else STRCPY(flist[fcnt++], name) ;   /* Save filename in file list. */
    }
}


file_modified()    /* Check if this file has been changed. */
{
  if (cfile->mtime == cstat.st_mtime) return(0) ;
  cfile->mtime = cstat.st_mtime ;
  return(1) ;
}


get_next_dir()     /* Get next directory name to monitor. */
{
  struct dinfo *temp ;
  int dirfound ;

  dirfound = 0 ;
  if (dirp)
    {
      CLOSEDIR(dirp) ;
      if (!strlen(cdir->next->d_name))     /* Complete pass done? */
        {
          docopy = 1 ;                     /* Always copy after first pass. */
          if (!copy_found)
            sleep((unsigned int) delay) ;  /* Nothing doing so go to sleep. */
          else copy_found = 0 ;
        }
      if (strcmp(curdir, cdir->next->d_name) != 0)
        if (fcnt) output("", REGULAR) ;
    }
  while (!dirfound)
    {
      STRCPY(curdir, fdir) ;
      if (strlen(cdir->next->d_name))
        {
          STRCAT(curdir, "/") ;
          STRCAT(curdir, cdir->next->d_name) ;
        }
      STRCPY(coff, cdir->next->d_name) ;
      if ((dirp = opendir(curdir)) == NULL)
        {
          if (EQUAL(curdir, fdir)) exit(0) ;  /* Nothing left to monitor. */
          else
            {
              temp = cdir->next ;
              if (cdir->next == dirs) dirs = cdir ;
              cdir->next = cdir->next->next ;
              free((char *) temp) ;           /* Lose this directory record. */
              no_dirs-- ;
            }
        }
      else dirfound = 1 ;     /* Directory found. */
    }
  cdir = cdir->next ;         /* Point to current directory. */
  loc = 0 ;                   /* Reset directory buffer pointer. */
}


get_next_entry()         /* Get next directory filename entry. */
{
  struct dirent *temp ;  /* Pointer to next directory entry. */

  for (;;)
    {
      if ((temp = readdir(dirp)) == NULL) return(0) ;
      if (temp->d_fileno == 0) return(0) ;
      SPRINTF(fname, "%s/%s", curdir, temp->d_name) ;
      if ((fd = open(fname, O_RDONLY)) != -1)
        {
          CLOSE(fd) ;
          cur = (struct dirent *) Malloc(sizeof(struct dirent)) ;
          bcopy((char *) temp, (char *) cur, (int) DIRSIZ(temp)) ;
          STAT(fname, &cstat) ;
          return(1) ;
        }
    }
}


get_options(argc,argv)     /* Read and process command line options. */
int argc ;
char *argv[] ;
{
  char next[MAXLINE] ;     /* The next command line parameter. */

  STRCPY(fdir, "/usr") ;   /* Default directory to monitor. */
  STRCPY(tdir, "/usr2") ;  /* Default directory to copy to. */
  STRCPY(rhost, "") ;      /* Default is no remote host. */

  INC ;
  while (argc > 0)
    {
      if (argv[0][0] == '-')
        switch (argv[0][1])
          {
            case 'c' : docopy = 0 ;        /* Don't copy files first time. */
                       break ;
            case 'd' : debug = 1 ;         /* Print status information. */
                       break ;
            case 'f' : INC ;               /* Start directory to monitor. */
                       getparam(fdir, argv, "-f needs start directory") ;
                       break ;
            case 'r' : INC ;               /* Name of remote host. */
                       getparam(rhost, argv, "-r needs remote host") ;
                       usercp = 1 ;
                       break ;
            case 's' : INC ;               /* Sleep period in seconds. */
                       getparam(next, argv, "-s needs sleep period") ;
                       delay = atoi(next) ;
                       break ;
            case 't' : INC ;               /* Directory to start copying to. */
                       getparam(tdir, argv, "-t needs directory to copy to") ;
                       break ;
            case 'v' : FPRINTF(stderr,"%s version 1.2.%1d\n",
                                      progname, PATCHLEVEL) ;
                       exit(1) ;
            default  : FPRINTF(stderr,"Usage: %s [-c] [-f fromdir]", progname) ;
                       FPRINTF(stderr," [-r hostname] [-s sleep] ") ;
                       FPRINTF(stderr," [-t todir] [-v]\n") ;
                       exit(1) ;
          }
      INC ;
    }
}


getparam(s, argv, errmes)
char *s, *argv[], *errmes ;
{
  if (*argv != NULL && argv[0][0] != '-') STRCPY(s, *argv) ;
  else
    { 
      FPRINTF(stderr,"%s: %s as next argument.\n", progname, errmes) ;
      exit(1) ;
    }
}


make_dir_entry()    /* If not there already, create a new directory record. */
{
  int i ;
  char tempdir[MAXLINE] ;          /* Temporary directory name. */
  struct dinfo *temp ;

  temp = cdir ;
  for (i = 0; i < no_dirs; i++)    /* Directory already being monitored? */
    {
      temp = temp->next ;
      STRCPY(tempdir, fdir) ;
      if (strlen(temp->d_name))
        {
          STRCAT(tempdir, "/") ;
          STRCAT(tempdir, temp->d_name) ;
        }
      if (EQUAL(tempdir, fname)) return(0) ;
    }

  temp = (struct dinfo *) Malloc(sizeof(struct dinfo)) ;
  temp->next = dirs->next ;
  dirs->next = temp ;
  dirs = temp ;

  STRCPY(dirs->d_name, "") ;
  if (strlen(coff))
    {
      STRCAT(dirs->d_name, coff) ;
      STRCAT(dirs->d_name, "/") ;
    }
  STRCAT(dirs->d_name, cur->d_name) ;
  no_dirs++ ;
  return(1) ;
}


make_file_entry()      /* Make a record for this new file. */
{
  struct finfo *temp ;

  if ((cstat.st_mode & S_IFMT) == REGULAR)
    {
      temp = (struct finfo *) Malloc(sizeof(struct finfo)) ;
      temp->next = files ;
      files = temp ;

      files->dirent = cur ;
      files->mtime = cstat.st_mtime ;
    }
}


no_record()     /* Check is this file is already being monitored. */
{
  if (files == NULL) return(1) ;
  cfile = files ;
  do
    if (cfile->dirent->d_fileno == cur->d_fileno) return(0) ;
  while ((cfile = cfile->next) != NULL) ;
  return(1) ;
}


output(name,filetype)
char name[MAXLINE] ;
int filetype ;
{
  char command[MAXLINE*7], rdirname[MAXLINE] ;
  int i ;

  switch (filetype)
    {
      case DIRECTORY : if (usercp)
                         SPRINTF(command, "%s -r %s/%s %s:%s",
                                 cname, fdir, name, rhost, curdir) ;
                       else
                         {
                           SPRINTF(rdirname, "%s/%s", tdir, name) ;
                           if ((fd = open(rdirname, O_RDONLY)) == -1)
                             SPRINTF(command, "mkdir %s", rdirname) ;
                           else
                             {
                               CLOSE(fd) ;
                               return ;
                             }
                         }
                       break ;
      case REGULAR   : if (usercp) SPRINTF(rdirname, "%s:%s", rhost, curdir) ;
                       else
                         {
                           STRCPY(rdirname, tdir) ;
                           if (strlen(coff))
                             {
                               STRCAT(rdirname, "/") ;
                               STRCAT(rdirname, coff) ;
                             }
                         }
                       STRCPY(command, cname) ;
                       for (i = 0; i < fcnt; i++)
                         {
                           STRCAT(command, " ") ;
                           STRCAT(command, fdir) ;
                           STRCAT(command, "/") ;
                           STRCAT(command, flist[i]) ;
                         }
                       STRCAT(command, " ") ;
                       STRCAT(command, rdirname) ;
    }
  if (system(command))
    FPRINTF(stderr, "%s [FAILED]: %s\n\n", progname, command) ;
  else if (debug) FPRINTF(stderr, "%s succeeded: %s\n\n", progname, command) ;

  fcnt = 0 ;
}


setup()
{
  dirs = (struct dinfo *) Malloc(sizeof(struct dinfo)) ;
  STRCPY(dirs->d_name, "") ;
  STRCPY(pdir, fdir) ;        /* Start directory for current cp request. */
  STRCPY(coff, "") ;          /* Name offset from start directory. */

  STRCPY(cp_name, "/bin/cp") ;          /* Default names. */
  STRCPY(rcp_name, "/usr/ucb/rcp") ;
#ifdef CP
  if (access(CP, X_OK)) STRCPY(cp_name, CP) ;
#endif CP
#ifdef RCP
  if (access(RCP, X_OK)) STRCPY(rcp_name, RCP) ;
#endif RCP

  if (usercp)                 /* Used by the output routine. */
    STRCPY(cname, rcp_name) ;
  else STRCPY(cname, cp_name) ;
  dirs->next = dirs ;
  cdir = dirs ;
}
