/*
 * The Naval Observatory clock (+1 202 653 0351) prints this every second:
 *
 *	*
 *	jjjjj ddd hhmmss UTC
 *
 * jjjjj	Julian date modulo 2400000
 * ddd		days since beginning of year
 * hhmmss	time of day in Universal Time Coordinated
 */

#include <stdio.h>
#include <time.h>
#include <sys/types.h>

#define	EPOCH		40587			/* UNIX starts JD 2440587, */
#define	leap(y, m)	((y+m-1 - 70%m) / m)	/* also known as 1/1/70 */
#define	TONE		'*'
#define	TIME		"\n%05ld %03d %02d%02d%02d UTC"

main(argc, argv)
int	argc;
char	*argv[];
{
	int	setflg = 0, prtflg = 0;
	int	y, d, h, m, s;
	long	j;
	time_t	now;
	int	c;

	while ((c = getopt(argc, argv, "sp")) != EOF)
		switch (c) {
		case 's': setflg++; break;
		case 'p': prtflg++; break;
		default:
			fprintf(stderr, "usage: %s [-s] [-p]\n", argv[0]);
			return 1;
		}
	if (setflg || prtflg) {
		while ((c = getchar()) != TONE)
			if (c == EOF)
				return 1;
		if (scanf(TIME, &j, &d, &h, &m, &s) != 5)
			return 1;
		now = (((j - EPOCH) * 24 + h) * 60 + m) * 60 + s;
		if (setflg && stime(&now) == -1)
			perror(argv[0]);
		if (prtflg)
			fputs(ctime(&now), stdout);
	} else {
		for (c = 0; c < 60; c++) {
			time(&now);
			s = (now % 60);
			m = (now /= 60) % 60;
			h = (now /= 60) % 24;
			d = (now /= 24) % 365;
			j = now + EPOCH;
			y = (now /= 365);
			d += 1 - leap(y, 4) + leap(y, 100) - leap(y, 400);
			putchar(TONE);
			printf(TIME, j, d, h, m, s);
			putchar('\n');
			fflush(stdout);
			sleep(1);
		}
	}
	return 0;
}
