/*
** rcuser -- allow users to perform functions at startup time
**
** by Steven Grimm, koreth@ssyx.ucsc.edu
** 3-29-89
*/

/* Default editor, if VISUAL environment variable isn't set */
#define VISUAL	"/usr/ucb/vi"

/* Command to display a file */
#define DISPLAY	"/bin/cat"

/*
** Command shell to test scripts with.  This should be the same
** shell that's invoked for user scripts in rc.users.
*/
#define SHELL "/bin/sh"

#include <pwd.h>
#include <stdio.h>
#include <errno.h>
#include <sys/file.h>
#include <sys/param.h>

/* The username and id that we're working on behalf of. */
char *username;
int  uid;
struct passwd *pent;

char *malloc();

/*
** Get a user's uid and, if necessary, name
*/
getuser(name)
char *name;
{
	if (name == NULL)
	{
		uid = getuid();
		pent = getpwuid(uid);
		if (pent != NULL)
			username = pent->pw_name;
	}
	else
	{
		username = name;
		pent = getpwnam(name);
		if (pent != NULL)
			uid = pent->pw_uid;
	}
}

/*
** Print an error and exit.
*/
panic(err)
char *err;
{
	perror(err);
	exit(-1);
}

/*
** Print usage and exit.
*/
usage(name)
char *name;
{
	fprintf(stderr,"Usage: %s [-l|-e|-d] [user]\n", name);
	fprintf(stderr,"\t-l - show startup script\n");
	fprintf(stderr,"\t-e - edit startup script\n");
	fprintf(stderr,"\t-d - delete startup script\n");
	fprintf(stderr,"\t-t - test startup script\n");
	fprintf(stderr,"\n\tusername may only be specified by superuser\n");
	exit(-1);
}

/*
** Create a file, owned by the appropriate user.
*/
create(file, uid)
char *file;
int uid;
{
	int fd;

	fd = open(file, O_WRONLY|O_CREAT, 0600);
	if (fd == -1)
		panic(file);

	close(fd);
	
/* fchown() is a BSDism */
	chown(file, uid, -1);
}

main(argc, argv)
int argc;
char **argv;
{
	char function, filename[MAXPATHLEN], *editor, *getenv();

	if (argc < 2)
	{
		getuser(NULL);
		function = 'l';
	} else
		if (argv[1][0] != '-')
			usage(argv[0]);
		else
			switch(argv[1][1]) {
			case 'l':
			case 'e':
			case 'd':
			case 't':
				function = argv[1][1];
				break;
			default:
				usage(argv[0]);
			}

/* If a username is given on the command line, and we are superuser, use it. */
	if (argc == 3 && getuid() == 0)
		getuser(argv[2]);
	else
		getuser(NULL);

/* Construct the name of the appropriate user's startup file. */
	strcpy(filename, RCDIR);
	strncat(filename, username, sizeof(filename)-sizeof(RCDIR)-1);

/* Now, if the function requires it, create the file if it doesn't exist. */
	if (function == 'e' && access(filename, F_OK) == -1)
		if (errno == ENOENT)
			create(filename, uid);
		else
			panic(filename);

/* Delete the file if necessary/possible. */
	if (function == 'd')
		if (unlink(filename) == -1)
			panic(filename);

/* That's all we need to be root for, so change our uid to something secure. */
	setreuid(uid, uid);

/* Now edit or show the file, as appropriate. */
	if (function == 'l')
		execl(DISPLAY, DISPLAY, filename, NULL);
	if (function == 'e')
	{
		if ((editor = getenv("VISUAL")) == NULL)
			editor = VISUAL;
		execl(editor, editor, filename, NULL);
	}
	if (function == 't')
	{
/* Duplicate the minimal environment under which the scripts are run */
		char *env[5];

		env[4] = NULL;
		env[3] = malloc(strlen(pent->pw_name)+6);
		sprintf(env[3], "USER=%s", pent->pw_name);
		env[2] = malloc(strlen(pent->pw_shell)+7);
		sprintf(env[2], "SHELL=%s", pent->pw_shell);
		env[1] = malloc(strlen(RCDIR)+4);
		sprintf(env[1], "PWD=%s", RCDIR);
		env[1][strlen(RCDIR)+3] = '\0';	/* lop off trailing / */
		env[0] = malloc(strlen(pent->pw_dir)+6);
		sprintf(env[0], "HOME=%s", pent->pw_dir);
		
		execle(SHELL, SHELL, filename, NULL, env);
	}
	exit(0);
}

