.TH TTYUSE 1
.SH NAME
ttyuse \- show terminal usage
.SH SYNOPSIS
.B ttyuse
[
.B \-l
] [
.B \-R
] [
.B \-w
wtmp ]
.I time
.IR "user " ...
.IR "/dev/* " ...
.br
.BR "ttyuse =" "     (to get a `how to use it' message)"
.SH DESCRIPTION
.I Ttyuse
writes (to the standard output) a summary of daily terminal usage.
If one or more
.IR user s
are named on the command line,
the report is limited to those users.
If one or more device names are given,
the report is limited to those devices.
(All--and only--command line arguments that begin with
.RB ` /dev/ '
are taken to be device names.)
And if a
.I time
argument is given, the report is limited to given date(s); the
time argument may take these forms:
.nf
.in +.5i
.ta \w'm/d-m/d  'u
m/d	a month and day (example:  5/15);
m/d-d	a month, starting day, and stopping day;
m/d-m/d	starting and stopping months and days;
m/d-	starting month and day
	(the current day is used as the ending day)
.fi
.in -.5i
In the absence of a
.I time
argument,
output for the current day is produced.
.PP
The leftmost of the 79 columns of output look like this:
.in +.5i
.nf
Mon Sep 23 1985
TT USE 12-1--2--3--4--5--6--7--8--~--10-11-12-1--
01 5.0                       Snorri              
02 8.7                         Mark  Mark::::::::
03 7.7                           MRoot::::::::Mar
05 0.8                         Root              
07 12. ado                        ~  Ado:::::::::
09 0.4                            ~   Ma         
13 3.9 UU 2U 2U UU22U UU UUUUU UU U2 U UUucUucp::
  39.3 <   2><   1><   1><   2><   5><   5><   4>
.in -.5i
.fi
The first line gives the date the report is for.
The second line provides headings for the lines that follow.
In those following lines, the
.RB ` TT '
columns give the
.IR ps (1)-style
abbreviation of the terminal the line of output is about,
and the
.RB ` USE '
columns give the total hours of use for the terminal on the
date the report is for.
Each other column represents a twenty-minute time period.
A capital letter in one of these columns means that a
user whose name begins with that letter logged in during
the time period; the user's name continues in lower case into
following columns for as long as they remain logged in
(followed by colons if they stay logged in for a long time).
If more than one login occurs during a time period, the
number of logins appears in the time period's column;
an asterisk appears if there were ten or more logins.
.PP
The final line for a date's report shows the total
terminal-hours for the day,
and the total number of terminals used during each two-hour period.
.PP
Reboots are shown by a
.RB ` ~ '
character in the relevant column of output;
time changes are shown by a
.RB ` | '
character in the `time-changed-from' column and a
.RB ` { '
character in the `time-changed-to' column.
These characters appear in the headings line and in lines
of output for terminals that were idle during the time
period when the reboot or time change occurred.
.PP
The
.RB ` USE '
columns are absent from reports for days with 25 hours
(Daylight Saving Time transition days).
.PP
These options are available:
.TP
.B \-l
Produce long lines of output (up to 131 columns) where each column
represents twelve minutes.  The final line of a date's report
shows the total number of terminals used during each one-hour
period.
.TP
.B \-R
Interpret the entire accounting file.
.TP
.BI "\-w " wtmp
Use the file whose name is given by
.I wtmp
as the accounting file,
rather than using the default name shown below.
.SH FILES
/usr/adm/wtmp
.SH SEE ALSO
ps(1)
.. @(#)ttyuse.n	1.1
