:
#
# Package	: (Trs2)
# Module	: rmthread.sh
# Programmer	: R. Stolfa (rjs@a.cs.okstate.edu)
# SCCSid	: @(#) rmthread.sh 1.2 89/12/19
#
# Purpose :	To delete a thread of trouble reports in the TRS
#		database system.
#
# Modification History:
#   04/12/88	Created
#   10/25/88	Added a user configurable "ROOT" to allow more than
#		one TRS on a system
#
#   10/16/89	Release 2 started.
#   12/19/89	Fixed minor bug in invocation of "V"
#

###
###	Copyright (c) 1989, Roland J. Stolfa,  Right to copy is
###	granted so long as it is not for monetary gain and this
###	message and all headers in all files remain in tact.
###
###	THE AUTHOR DOES NOT MAKE ANY WARRANTIES, EITHER EXPRESS
###	OR IMPLIED, AS TO ANY MATTER WHATSOEVER, INCLUDING WITHOUT
###	LIMITATION, THE CONDITION OF THIS DISTRIBUTION, ITS
###	MERCHANTABILITY OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
###

#
# Get configured.
#
if [ "${TRSROOT}" != "" ]
then
	ROOT = ${TRSROOT}
else
ROOT=/u/rjs/lib/Trs
fi
Entry=${ROOT}/Entry
Xref=${ROOT}/Xref
Plock=${ROOT}/LCK.TRS

BIN=/u/rjs/bin
PATH=${BIN}:/bin:/usr/bin
export PATH
umask 022
Pager=${PAGER:-pg}

Temp=/tmp/trs1.$$
Temp2=/tmp/trs2.$$
trap "rm -f /tmp/trs*$$ ; exit 1" 1 2 15

#
# Get the tread to delete.
#
thread="$*"
while [ "${thread}" = "" ]
do
	${BIN}/print "Enter thread to delete? "
	read thread

	if test \! -s ${Entry}/${thread}
	then
		echo "Invalid thread.  Try again"
		thread=""
	fi
done

#
# Search backwards (if possible) for head of thread.
#
needle="+"
while [ "${needle}" != "" ]
do
	needle="`grep '^needle=' ${Entry}/${thread} | awk -F= '{print $2}'`"
	if [ "${needle}" != "" ]
	then
		thread="${needle}"
	fi
done

#
# ASSERT:
#	At this point, thread is the original trouble report ticket
#	number.  Now let's keep that number safe and display the thread
#	to assure that it is the one that needs to be removed.
#

ptr="${thread}"
echo "The following is the listing of this thread."
echo ""
while [ "${ptr}" != "" ]
do
	echo "ticket=${ptr}"
	echo "reporter=`ls -l ${Entry}/${ptr} | awk '{print $3}'`"
	cat ${Entry}/${ptr}
	echo ""
	ptr="`grep '^thread=' ${Entry}/${ptr} | awk -F= '{print $2}'`"
done | ${Pager}

#
# Prompt for removal.
#
yesno=""
while [ "${yesno}" = "" ]
do
	${BIN}/print "Is this the thread you want to delete? (Y/N) "
	read yesno
done

if [ "${yesno}" = "n" -o "${yesno}" = "N" ]
then
	exit
fi

#
# Ok.  We have permission.  Just remove the whole stupid thing...
#
rm -f ${Temp}
ptr=${thread}
while [ "${ptr}" != "" ]
do
	echo "Removing ticket ${ptr}"
	echo ${ptr} >> ${Temp}
	thread="`grep '^thread=' ${Entry}/${ptr} | awk -F= '{print $2}'`"
	rm -f ${Entry}/${ptr}
	ptr="${thread}"
done
sort -u ${Temp} > ${Temp2}
pid=`P -wel ${Plock}`
for i in ${Xref}/*
do
	comm -23 $i ${Temp2} | sort -u > ${Temp}
	cp ${Temp} $i
done
V -i ${pid} -l ${Plock}

rm -f ${Temp} ${Temp2}
