:
#
# Package	: (Trs2)
# Module	: report.sh
# Programmer	: R. Stolfa (rjs@a.cs.okstate.edu)
# SCCSid	: @(#) report.sh 1.2 89/12/19
#
# Purpose :	To scan the TRS database and extract "reasonable"
#		information.  This information will be presented
#		on the screen in a format suitable for printing
#
# Command line syntax:
#		report <flags>
#		where <flags> are some set of the following
#
#		t=<thread id>
#		k=<keyword to search on>
#		d=<date in YYMMDD format>
#		r=<reporter (userid)>
#		e=<equipment id string (inventory number?)>
#
# Modification History:
#   04/12/88	Created
#   10/25/88	Added a user configurable "ROOT" to allow more than
#		one TRS on a system
#
#   10/16/89	Release 2 started.
#

###
###	Copyright (c) 1989, Roland J. Stolfa,  Right to copy is
###	granted so long as it is not for monetary gain and this
###	message and all headers in all files remain in tact.
###
###	THE AUTHOR DOES NOT MAKE ANY WARRANTIES, EITHER EXPRESS
###	OR IMPLIED, AS TO ANY MATTER WHATSOEVER, INCLUDING WITHOUT
###	LIMITATION, THE CONDITION OF THIS DISTRIBUTION, ITS
###	MERCHANTABILITY OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
###

#
# Get configured.
#
if [ "${TRSROOT}" != "" ]
then
	ROOT = ${TRSROOT}
else
ROOT=/u/rjs/lib/Trs
fi
Entry=${ROOT}/Entry
Xref=${ROOT}/Xref

BIN=/u/rjs/bin
PATH=${BIN}:/bin:/usr/bin
export PATH
umask 022
Pager=${PAGER:-pg}

Awkprog=/tmp/trs1.$$
Temp=/tmp/trs2.$$
Temp2=/tmp/trs3.$$
trap "rm -f /tmp/trs*$$ ; exit 1" 1 2 15

#
# Parse the command line
#
thread=""
key=""
date=""
reporter=""
equip=""
cat > ${Awkprog} << 'EOF'
BEGIN	{ FS = "="; }
{
	if (NF == 2) {
		char = substr ($1, 0, 1);
		if ((char == "t") || (char == "T"))
			printf "T\n";
		else if ((char == "k") || (char == "K"))
			printf "K\n";
		else if ((char == "d") || (char == "D"))
			printf "D\n";
		else if ((char == "r") || (char == "R"))
			printf "R\n";
		else if ((char == "e") || (char == "E"))
			printf "E\n";
	}
}
EOF
for i in $*
do
	case `echo $i | awk -f ${Awkprog}` in
	T)
		thread="`echo $i | awk -F= '{print $2}'`"
		continue;;
	K)
		item=`echo $i | awk -F= '{print $2}'`
		key=`soundex ${item}`
		continue;;
	D)
		date="`echo $i | awk -F= '{print $2}'`"
		continue;;
	R)
		reporter="`echo $i | awk -F= '{print $2}'`"
		continue;;
	E)
		equip="`echo $i | awk -F= '{print $2}'`"
		continue;;
	esac
done
rm -f ${Awkprog}

#
# Separate out a thread (if required).
#
if [ "${thread}" != "" ]
then
	#
	# Ok.  Let's generate a thread list.
	#
	if test ! -s ${Entry}/${thread}
	then
		echo "Invalid thread id.  Try again."
		exit
	fi
	rm -f ${Temp}
	#
	# Find head of thread
	#
	needle=${thread}
	while [ "${needle}" != "" ]
	do
		thread=${needle}
		needle="`grep '^needle=' ${Entry}/${needle} | awk -F= '{print $2}'`"
	done
	#
	# List the members of the thread
	#
	while [ "${thread}" != "" ]
	do
		echo "${thread}" >> ${Temp}
		thread="`grep '^thread=' ${Entry}/${thread} | awk -F= '{print $2}'`"
	done
else
	#
	# Get all trouble tickets, system wide
	#
	cat ${Xref}/Entry > ${Temp}
fi
sort -u ${Temp} > ${Temp2}
mv ${Temp2} ${Temp}

#
# Now lets get the key field taken care of.
#
if [ "${key}" != "" ]
then
	if test -s ${Xref}/${key}
	then
		comm -12 ${Temp} ${Xref}/${key} | sort -u > ${Temp2}
		mv ${Temp2} ${Temp}
	else
		echo "Key >${key}< doesn't exist.  Continuing..."
	fi
fi

#
# Ok.  Now let's generate the subset of the list that has occured on
# the date in question.
#
if [ "${date}" != "" ]
then
	grep "${date}" < ${Temp} | sort -u > ${Temp2}
	mv ${Temp2} ${Temp}
fi

#
# Do the awking for a particular reporter (if necessary).
#
if [ "${reporter}" != "" ]
then

	cat > ${Awkprog} << 'EOF'
{
	if (NR == 1) {
		reporter = $1;
	} else if (substr($3, 0, length(reporter)) == reporter) {
		printf "%s\n", $NF;
	}
}
EOF

	echo "${reporter}" > ${Temp2}
	ls -l `cat ${Temp}` >> ${Temp2}
	awk -f ${Awkprog} < ${Temp2} > ${Temp}
	rm -f ${Temp2} ${Awkprog}
fi

#
# Do the greping for a particular piece of equipment (if necessary).
#
if [ "${equip}" != "" ]
then
	cat ${Temp} | while read x
	do
		grep -l "^equipment=${equip}*" $x > ${Temp2}
	done
	sort -u ${Temp2} > ${Temp}
fi

#
# Ok.  More the junk to the screen...
#
for i in `cat ${Temp}`
do
	fn=${Entry}/$i
	if test -s ${fn}
	then
		echo "ticket=$i"
		echo "reporter=`ls -l ${fn} | awk '{print $3}'`"
		cat ${fn}
		echo ""
	fi
done | ${Pager}

#
# Now clean up and exit.
#
rm -f ${Temp} ${Temp2}
