/*
 * Package	: LIBRARY (lockp)
 * Module	: T_V.c
 * Functions	: main, usage
 * Programmer	: R. Stolfa (rjs@a.cs.okstate.edu)
 * SCCSid	: @(#) V.c 1.2 89/10/30
 *
 * Purpose :	This program remove a lock file as generated in
 *		"T_P.c" if the associated PID matches
 *
 * Modification History:
 *   08/31/89	Created
 *   10/30/89	Changed to reflect changes in "unlockp(3L)" code.
 */

/**
***	Copyright (c) 1989, Roland J. Stolfa,  Right to copy is
***	granted so long as it is not for monetary gain and this
***	message and all headers in all files remain in tact.
***
***	THE AUTHOR DOES NOT MAKE ANY WARRANTIES, EITHER EXPRESS
***	OR IMPLIED, AS TO ANY MATTER WHATSOEVER, INCLUDING WITHOUT
***	LIMITATION, THE CONDITION OF THIS DISTRIBUTION, ITS
***	MERCHANTABILITY OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
**/

static char	*sccsid = "@(#) V.c 1.2 89/10/30";

#include	<stdio.h>

#include	"lockp.h"

#define		BUFSZ		80

main (argc, argv)
	int	argc;
	char	*argv[];
{
	extern int	optind;
	extern char	*optarg;
	int		c;

	char	*lockfn;	/* The name of the lockfile */
	int	pid;		/* Pid of original parent */

	/*
	 * Parse those comand line parameters.
	 */
	if (argc < 5)
		usage ();
		/*NOTREACHED*/
	pid = 0;
	lockfn = NULL;
	while ((c = getopt (argc, argv, "i:l:")) != EOF)
		switch (c) {
		case 'i':	pid = atoi(optarg);	break;
		case 'l':	lockfn = optarg;	break;
		default:	usage(); /*NOTREACHED*/	break;
		}
	if ((pid == 0) || (lockfn == NULL))
		usage();
		/*NOTREACHED*/

	/*
	 * Call "unlockp(3L)" to check on sanity and do all the right
	 * things about getting rid of the lock file.  If it returns
	 * an error condition, bitch about it.
	 */
	switch (unlockpp(lockfn,pid)) {
	case LOCKP_BADF:
		fprintf (stderr, "V: bad lock file name\n");
		exit (-1);
		/*NOTREACHED*/
	break;

	case LOCKP_EMPTY:
		fprintf (stderr, "V: lock file is empty\n");
		exit (-1);
		/*NOTREACHED*/
	break;

	case LOCKP_BADPID:
		fprintf (stderr, "V: lock file is not owned by given pid\n");
		exit (-1);
		/*NOTREACHED*/
	break;

	default:
		exit (0);
		/*NOTREACHED*/
	break;
	}
}

usage ()
{
	fprintf (stderr,
		"Usage: V -i <pid> -l <fn>\n");
	exit (-1);
}
