/*
 * Program	: LIBRARY (lockp)
 * Module	: T_P.c
 * Functions	: main, usage
 * Programmer	: R. Stolfa (rjs@a.cs.okstate.edu)
 * SCCSid	: @(#) P.c 1.2 89/10/30
 *
 * Purpose :	To provide a process locking facility to the shell.
 *
 * Modification History:
 *   05/11/89	Created
 *   08/31/89	Modified to work with "T_V.c" by outputing the PID of
 *		the process that made the lockfile (this one) on stdout
 *		for later use by "T_V.c" in removing that lock.
 */

/**
***	Copyright (c) 1989, Roland J. Stolfa,  Right to copy is
***	granted so long as it is not for monetary gain and this
***	message and all headers in all files remain in tact.
***
***	THE AUTHOR DOES NOT MAKE ANY WARRANTIES, EITHER EXPRESS
***	OR IMPLIED, AS TO ANY MATTER WHATSOEVER, INCLUDING WITHOUT
***	LIMITATION, THE CONDITION OF THIS DISTRIBUTION, ITS
***	MERCHANTABILITY OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
**/

static char	*sccsid = "@(#) P.c 1.2 89/10/30";

#include	<stdio.h>

#define		FALSE		0
#define		TRUE		1

main (argc, argv)
	int	argc;
	char	*argv[];
{
	extern int	optind;
	extern char	*optarg;
	int		c;

	int	exponential,
		fixed,
		delay,
		warn;
	char	*fnptr;

	/*
	 * Parse those command line arguments.
	 */
	exponential = fixed = FALSE;
	fnptr = NULL;
	warn = FALSE;
	while ((c = getopt (argc, argv, "ef:l:w")) != EOF) {
		switch (c) {
		case 'e':
			exponential = TRUE;
			delay = 1;
#ifdef DEBUG
			printf ("exponential delay set to %d\n", delay);
#endif
			break;
		case 'f':
			fixed = atoi (optarg);
			if (fixed > 101)
				fixed = 101;
			delay = fixed;
#ifdef DEBUG
			printf ("fixed delay set to %d\n", delay);
#endif
			break;
		case 'l':
			fnptr = optarg;
#ifdef DEBUG
			printf ("got >%s< as lock file name\n", fnptr);
#endif
			break;
		case 'w':
			warn = TRUE;
			break;
		default:
			usage();
			/*NOTREACHED*/
		}
	}
	if ((exponential == fixed) || (fnptr == NULL))
		usage();
		/*NOTREACHED*/

	while (lockp (fnptr) < 0) {
		if (warn == TRUE)
			fprintf (stderr,
				"Waiting on lock file >%s<...\n", fnptr);
		sleep (delay);
		if (exponential == TRUE) {
			if (delay != 100)
				delay = delay * 10;
#ifdef DEBUG
			printf ("Adjusting exponential delay to %d\n", delay);
#endif
		}
	}
#ifdef DEBUG
	printf ("P: exiting\n");
#endif
	printf ("%d\n", getpid());
}

usage ()
{
	fprintf (stderr, "Usage: P { -e / -f<fixed> } [-w] -l <fn>\n");
	exit (-1);
}
