:
#
# Package	: (Trs2)
# Module	: trouble.sh
# Programmer	: R. Stolfa (rjs@a.cs.okstate.edu)
# SCCSid	: @(#) trouble.sh 1.2 89/12/19
#
# Purpose :	To enter trouble reports into the TRS database system.
#
# Modification History:
#   04/11/88	Created
#   04/12/88	Added hooks for recording the new trouble number in the
#		environment variable NTN for use in "followup"
#   10/25/88	Added user configurable "ROOT" to allow more than
#		one TRS on a system
#
#   10/16/89	Release 2 started.
#

###
###	Copyright (c) 1989, Roland J. Stolfa,  Right to copy is
###	granted so long as it is not for monetary gain and this
###	message and all headers in all files remain in tact.
###
###	THE AUTHOR DOES NOT MAKE ANY WARRANTIES, EITHER EXPRESS
###	OR IMPLIED, AS TO ANY MATTER WHATSOEVER, INCLUDING WITHOUT
###	LIMITATION, THE CONDITION OF THIS DISTRIBUTION, ITS
###	MERCHANTABILITY OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
###

#
# Get configured.
#
if [ "${TRSROOT}" != "" ]
then
	ROOT = ${TRSROOT}
else
ROOT=/u/rjs/lib/Trs
fi
Entry_dir=${ROOT}/Entry
Seq=${ROOT}/sequence
Xref=${ROOT}/Xref
Plock=${ROOT}/LCK.TRS

BIN=/u/rjs/bin
PATH=${BIN}:/bin:/usr/bin
export PATH
umask 000
Pager=${PAGER:-pg}

Temp=/tmp/trs.$$
trap "rm -f /tmp/trs*$$ ; exit 1" 1 2 15
rm -f ${Temp}

#
# Prompt for what piece of equipment is down.
#
equipment=""
while [ "${equipment}" = "" ]
do
	${BIN}/print "Enter equipment ID string? "
	read equipment
done
echo "equipment=${equipment}" >> ${Temp}

#
# Get the keywords to link the file in "Entry" to in each
# of their respective "SOUNDEX" equivalents files.
#
echo "Enter the keywords that are to be associated with this"
echo "report one per line, ending with a blank line."
${BIN}/print "keywords=" >> ${Temp}
keywords=""
dummy="+"
while [ "${dummy}" != "" ]
do
	read dummy
	if [ "${dummy}" != "" ]
	then
		${BIN}/print "${dummy} " >> ${Temp}
		keywords="${keywords}`soundex ${dummy}` "
	fi
done
echo "" >> ${Temp}

#
# Enter the report.
#
echo "Enter report, ending with a blank line"
dummy="+"
while [ "${dummy}" != "" ]
do
	read dummy
	if [ "${dummy}" != "" ]
	then
		echo "desc=${dummy}" >> ${Temp}
	fi
done

#
# Handle the process locking on the Entry spool to allow us to copy
# into that area safe from race conditions.
#
pid=`P -ewl ${Plock}`
seqence=`cat ${Seq}`
entry="`date '+%y%m%d'`.${seqence}"
expr ${seqence} + 1 > ${Seq}
mv ${Temp} ${Entry_dir}/${entry}
V -i ${pid} -l ${Plock}

#
# Report the "trouble ticket" number for future 'threading'.
#
echo " "
echo "Your trouble ticket number is ${entry}"
echo "save this number for future reference."

#
# Record the new trouble number in the environment variable NTN.
#
NTN=${entry}

#
# Now enter the "Entry" into a file for each of the "SOUNDEX"'ed
# keywords.  This is an attempt to make the system easier to search.
#
echo ${entry} >> ${Xref}/Entry
for i in ${keywords}
do
	echo ${entry} >> ${Xref}/$i
done

#
# Ok.  Let's be clean...
#
rm -f ${Temp}
