/*
 * Package	: (Trs2)
 * Module	: soundex.c
 * Functions	: main, soundex
 * Programmer	: R. Stolfa (rjs@a.cs.okstate.edu)
 * SCCSid	: @(#) soundex.c 1.2 89/12/19
 *
 * Purpose :	This program implements the SOUNDEX procedure as
 *		outlined on page 655 of "Database Design" by
 *		Gio Wiederhold.  This procedure was originally
 *		introduced by Odell & Russel (1918) and was
 *		described by McEwen (1974).
 *
 * Usage :	soundex <string1> <string2> ... <stringN>
 *
 * Modification History:
 *   00/00/00	Created
 */

/**
***	Copyright (c) 1989, Roland J. Stolfa,  Right to copy is
***	granted so long as it is not for monetary gain and this
***	message and all headers in all files remain in tact.
***
***	THE AUTHOR DOES NOT MAKE ANY WARRANTIES, EITHER EXPRESS
***	OR IMPLIED, AS TO ANY MATTER WHATSOEVER, INCLUDING WITHOUT
***	LIMITATION, THE CONDITION OF THIS DISTRIBUTION, ITS
***	MERCHANTABILITY OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
**/

static char	*sccsid = "@(#) soundex.c 1.2 89/12/19";

#include	<stdio.h>

#define		BS		200

main (argc, argv)
int	argc;
char	*argv[];
{
	char	sound[BS];
	int	i;

	if (argc == 1) {
		fprintf (stderr,
			"Usage: soundex <string1> <string2> ... <stringN>\n");
		exit (-1);
	}

	for (i = 1; i < argc; i ++) {
		soundex (argv[i], sound);
		printf ("%s\n", sound);
	}
}

soundex (word, sound)
char	word[],		/* String to convert to SOUNDEX */
	sound[];	/* Output SOUNDEX */
{
	int	outpos,		/* Current output position in SOUNDEX */
		j;		/* Index into word */

	/* Initialize return word */
	outpos = 0;
	sound[outpos] = '\0';

	/* If the word is null, then the output should be null */
	if (strlen(word) == 0)
		return;

	/* Copy first character of word to SOUNDEX */
	sound[outpos] = toupper (word[0]);

	for (j = 1; j < strlen (word); j ++) {

		/* Convert each character to uppercase */
		word[j] = toupper(word[j]);

		switch (word[j]) {

		/* Replace Labials with "1" */
		case 'B':
		case 'F':
		case 'P':
		case 'V':
			if (sound[outpos] != '1') {
				outpos ++;
				sound[outpos] = '1';
			}
			break;

		/* Replace Gutterals & sibilants with "2" */
		case 'C':
		case 'G':
		case 'J':
		case 'K':
		case 'Q':
		case 'S':
		case 'X':
		case 'Z':
			if (sound[outpos] != '2') {
				outpos ++;
				sound[outpos] = '2';
			}
			break;

		/* Replace Dentals with "3" */
		case 'D':
		case 'T':
			if (sound[outpos] != '3') {
				outpos ++;
				sound[outpos] = '3';
			}
			break;

		/* Replace Longliquids with "4" */
		case 'L':
			if (sound[outpos] != '4') {
				outpos ++;
				sound[outpos] = '4';
			}
			break;

		/* Replace Nasals with "5" */
		case 'M':
		case 'N':
			if (sound[outpos] != '5') {
				outpos ++;
				sound[outpos] = '5';
			}
			break;

		/* Replace Shortliquids with "6" */
		case 'R':
			if (sound[outpos] != '6') {
				outpos ++;
				sound[outpos] = '6';
			}
			break;
		}
	}

	/* Terminate the soundex string */
	outpos ++;
	sound[outpos] = '\0';

	/* Forcably trunicate soundex to 4 characters */
	sound[4] = '\0';
}
