/*
 * Package	: LIBRARY (lockp)
 * Module	: lockp.c
 * Functions	: lockp, unlockp
 * Programmer	: R. Stolfa (rjs@a.cs.okstate.edu)
 * SCCSid	: @(#) lockp.c 1.3 89/10/30
 *
 * Purpose :	To provide a system portable way of binary semaphores
 *		(via linked files in the file system) for Un*x.
 *
 * Modification History:
 *   05/08/89	Created
 *   10/03/89	Ported to ULTRIX
 *   10/30/89	Optimized generation of temporary file name.
 *      -	Rewrote "unlockp" to do more of the job.
 */

/**
***	Copyright (c) 1989, Roland J. Stolfa,  Right to copy is
***	granted so long as it is not for monetary gain and this
***	message and all headers in all files remain in tact.
***
***	THE AUTHOR DOES NOT MAKE ANY WARRANTIES, EITHER EXPRESS
***	OR IMPLIED, AS TO ANY MATTER WHATSOEVER, INCLUDING WITHOUT
***	LIMITATION, THE CONDITION OF THIS DISTRIBUTION, ITS
***	MERCHANTABILITY OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
**/

static char	*sccsid = "@(#) lockp.c 1.3 89/10/30";

#include	<stdio.h>
#ifdef ULTRIX
#include	<sys/file.h>
#else
#include	<fcntl.h>
#endif

extern char	*strrchr();

#include	"lockp.h"

/* #define		DEBUG /* */

#define		BIGBUFSZ	512
#define		SMLBUFSZ	80

int lockp (final)
	char	*final;
{
	int	len,
		pidlen,
		fd;
	char	*ptr,
		fn[BIGBUFSZ],
		pidbuf[SMLBUFSZ];

	/*
	 * Generate the temporary file name.
	 */
	fn[0] = '\0';
	if ((ptr = strrchr (final, '/')) != NULL) {
		len = ptr - final + 1;
		strncpy (fn, final, len);
		fn[len] = '\0';
	}
	strcat (fn, "LCK.XXXXXX");
#ifdef DEBUG
	fprintf (stderr, "lockp:  generated >%s< as lock fn pattern\n", fn);
#endif
	mktemp (fn);
#ifdef DEBUG
	fprintf (stderr, "lockp:  generated >%s< as lock fn\n", fn);
#endif

	/*
	 * Attempt to create the lock temporary file.  If anything
	 * goes wrong, return -1.
	 */
	sprintf (pidbuf, "%d\n", getpid());
	pidlen = strlen (pidbuf) + 1;
	if ((fd = open (fn, O_WRONLY | O_CREAT | O_TRUNC, 0644)) < 0) {
#ifdef DEBUG
		fprintf (stderr, "lockp:  open(2) failed on >%s<\n", fn);
		perror (fn);
#endif
		return (-1);
	}
	if (write (fd, pidbuf, pidlen) != pidlen) {
#ifdef DEBUG
		fprintf (stderr, "lockp:  write(2) failed\n");
#endif
		close (fd);
		unlink (fn);
		return (-1);
	}
	close (fd);

	/*
	 * Now comes the real locking.  If the "link(2)" function fails,
	 * someone else already has the lock.  Else we have it.
	 */
	if (link (fn, final) < 0) {
#ifdef DEBUG
		fprintf (stderr, "lockp:  link(2) failed\n");
#endif
		unlink (fn);
		return (-1);
	}

	/*
	 * Now let's clean up the directory by removing the temp file.
	 */
	unlink (fn);
	return (0);
}

int unlockpp (final, pid)
	char	*final;
	int	pid;
{
	FILE	*fp;		/* File pointer for lockfile */
	char	buff[SMLBUFSZ];

	/*
	 * Get the lock file open and read it's id.
	 */
	if ((fp = fopen (final, "r")) == NULL) {
#ifdef DEBUG
		fprintf (stderr, "unlockp:  fopen(3) failed\n");
		perror (lockfn);
#endif
		return (LOCKP_BADF);
	}
	if (fgets (buff, SMLBUFSZ, fp) == NULL) {
#ifdef DEBUG
		fprintf (stderr, "unlockp:  lock file empty\n");
#endif
		fclose (fp);
		return (LOCKP_EMPTY);
	}
	fclose (fp);
	if (atoi (buff) != pid) {
#ifdef DEBUG
		fprintf (stderr,
			"unlockp:  lock file not owned by this process\n");
#endif
		return (LOCKP_BADPID);
	}

	/*
	 * If we get to here, we have found the correct lock that we
	 * are looking for, it has the stated PID in it, so we may
	 * unlock it.
	 *
	 * NOTE:  This assumes that the lock file is owned by us.  If
	 *	  this is not the case, chaos may reign...
	 */
	unlink (final);
	return (0);
}
