:
#
# Package	: (Trs2)
# Module	: followup.sh
# Programmer	: R. Stolfa (rjs@a.cs.okstate.edu)
# SCCSid	: @(#) followup.sh 1.2 89/12/19
#
# Purpose :	To 'needle & thread' TRS records together.
#
# Modification History:
#   04/12/88	Created
#   10/25/88	Added user configurable "ROOT" to allow more than
#		one TRS to exist on a particular system.
#
#   10/16/89	Release 2 started.
#

###
###	Copyright (c) 1989, Roland J. Stolfa,  Right to copy is
###	granted so long as it is not for monetary gain and this
###	message and all headers in all files remain in tact.
###
###	THE AUTHOR DOES NOT MAKE ANY WARRANTIES, EITHER EXPRESS
###	OR IMPLIED, AS TO ANY MATTER WHATSOEVER, INCLUDING WITHOUT
###	LIMITATION, THE CONDITION OF THIS DISTRIBUTION, ITS
###	MERCHANTABILITY OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
###

#
# Get configured.
#
if [ "${TRSROOT}" != "" ]
then
	ROOT = ${TRSROOT}
else
ROOT=/u/rjs/lib/Trs
fi
Entry=${ROOT}/Entry

BIN=/u/rjs/bin
PATH=${BIN}:/bin:/usr/bin
export PATH
umask 022
Pager=${PAGER:-pg}

#
# Ok.  Get the 'trouble ticket' number.
#
num="$*"
if test ! -s ${Entry}/${num}
then
	echo "Invalid trouble ticket number.  Try again."
	num=""
fi
while [ "${num}" = "" ]
do
	${BIN}/print "Enter trouble ticket number? "
	read num

	if test ! -s ${Entry}/${num}
	then
		echo "Invalid trouble ticket number.  Try again."
		num=""
	fi
done

#
# Follow it's threads until you reach the last one.
#
thread="+"
while [ "${thread}" != "" ]
do
	thread="`grep '^thread=' ${Entry}/${num} | awk -F= '{print $2}'`"
	if [ "${thread}" != "" ]
	then
		num="${thread}"
	fi
done

#
# Display last entry.
#
echo "Last entry as follows:"
echo ""
echo "ticket=${num}"
echo "reporter=`ls -l ${Entry}/${num} | awk '{print $3}'`"
${Pager} ${Entry}/${num}
echo ""
yesno=""
while [ "${yesno}" = "" ]
do
	${BIN}/print "Is this the correct one? (Y/N) "
	read yesno
done

#
# If incorrect, try again.
#
if [ "${yesno}" = "N" -o "${yesno}" = "n" ]
then
	exec ${BIN}/followup
fi

#
# Ok.  Generate a new trouble report and then fix the threading.
# Do this by 'including' the trouble ticket generator.
#
number=${num}
. ${BIN}/trouble
echo "thread=${NTN}" >> ${Entry}/${number}
echo "needle=${num}" >> ${Entry}/${NTN}
