/*
 * tallow.c - temporarily add someone to your .rhosts file.
 *
 * usage: tallow [-c] user host [minutes]
 *        tallow [-c] host user [minutes
 *
 *
 * tcjones@watdragon
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/time.h>
#include <netdb.h>
#include <pwd.h>

#define DEF_AT_TIME 600			/* seconds */
#define EDIT "/usr/ucb/edit"
#define MAIL "/usr/ucb/mail"
#define ECHO "/bin/echo"
#define AT "/usr/bin/at -s"

main(argc, argv)
int argc;
char **argv;
{
	extern char *getenv();
	extern char *mktemp();
	extern char *index();
	extern struct passwd *getpwuid();

	FILE *rfp, *tfp, *fopen(), *fclose();

	char *progname;
	char *tmp = mktemp("/tmp/tallow.XXXXXXXXX");
	register char *runtime;
	register char *host;
	register char *user;
	char date[26];
	char rhosts[40];
	struct passwd *pwd;
	register int seconds = DEF_AT_TIME;
	int	confirm = 0;
	struct timeval v;

	/* 
	 * This program's name.
	 *
	 */
	progname = *argv++;

	/*
	 * Find out if we found out who we are etc etc.
	 *
	 */
	if ((pwd = getpwuid(getuid())) == NULL){
		fprintf(stderr, "%s: Could not getpwuid\n", progname);
	}


	/*
	 * Open the temporary file that we will write the at(1) commands to
	 * for the removal of the .rhosts entry.
	 *
	 */
	if ((tfp = fopen(tmp, "w")) == NULL) {
		printf("Could not open %s, .rhosts untouched\n", tmp);
		diy();
		exit(1);
	}


	/*
	 * If the -c option is present, record that and move on through the
	 * command line options as normal.
	 *
	 */
	if (argc > 1 && !strcmp(*argv, "-c")) {
		confirm = 1;
		argc--;
		argv++;
	}


	/* 
	 * If there are 3 arguments only (e.g. tallow fred watmath) then
	 * no time has been given so use the default. Otherwise if there
	 * are not exactly 4 arguments (e.g. tallow fred watmath 30) we
	 * have an error. 
	 *
	 */
	if (argc != 4 && argc != 3) usage(progname);


	/*
	 * The host name and the user name can appear in either order. If
	 * we can't recognise a hostname in either of them then get out.
	 * Set up the host and user pointers appropriately...
	 *
	 */
	if (gethostbyname(*argv) == NULL) {
		if (gethostbyname(*(argv+1)) == NULL) {
			printf("%s: neither %s nor %s are valid machine names.\n",
				*argv, *(argv+1));
			usage(progname);
		}
		else {
			user = *argv;
			host = *(argv+1);
		}
	}
	else {
		host = *argv;
		user = *(argv+1);
	}

	/*
	 * Skip over the host and user names.
	 *
	 */
	argv+=2;


	/*
	 * Calculate the number of seconds required until the .rhosts entry
	 * should be removed. This is either the default or 60 * whatever 
	 * they entered.
	 *
	 */
	seconds = (*argv) ?  60*(atoi(*argv)) : DEF_AT_TIME;


	/*
	 * Make sure everything looks ok.
	 *
	 */
	if (seconds <= 0) {
		printf("%s: Invalid time %d\n", progname, seconds);
		exit(1);
	}


	/*
	 * Try to open their .rhosts file.
	 *
	 */
	sprintf(rhosts, "/u/%s/.rhosts", pwd->pw_name);
	if ((rfp = fopen(rhosts, "a")) == NULL) {
		printf("%s: Could not open %s\n", progname, rhosts);
		exit(1);
	}

	/*
	 * Add the new entry at the end and close the file.
	 *
	 */
	fprintf(rfp, "%s %s\n", host, user);
	fclose(rfp);


	/*
	 * Start to produce the file for at. The first thing it must do is
	 * edit the .rhosts and remove the line. Use a here document.
	 *
	 */
	fprintf(tfp, "%s>/dev/null %s<<*\ng/^%s %s$/d\nw\n*\n",
		EDIT, rhosts, host, user);


	/*
	 * If they want confirmation, arrange to send them some mail
	 * when it is done. Could send them the .rhosts file too.
	 *
	 */
	if (confirm) {
		fprintf(tfp,"%s \\\"%s %s\\\" removed from %s|%s -s %s %s\n",
			ECHO,host,user,rhosts,MAIL,progname,pwd->pw_name);
	}


	/*
	 * Close the file for at.
	 *
	 */
	fclose(tfp);

	/*
	 * Get the time of day so we can work out when to schedule at for.
	 *
	 */
	if (gettimeofday(&v, NULL) == -1){
		fprintf(stderr, "%s: Could not get time of day.\n", progname);
		diy();
		exit(1);
	}

	/* 
	 * Add on the required number of seconds and convert the time to a string
	 * like "Sun Sep 16 01:03:52 1973\n\0"
	 *
	 */
	v.tv_sec += seconds;
	strcpy(date, ctime((time_t *)(&(v.tv_sec))));


	/*
	 * Find the first colon in the above, set the next colon (3 chars on)
	 * to '\0', and move back a couple of charaters to the start of the 
	 * time. Thus with the above string we'd end up with
	 *
	 * "Sun Sep 16 01:03'\0'52 1973\n\0"
	 *             ^
	 *             |
	 *     runtime--
	 *
	 * With runtime pointing at the null-terminated time.
	 *
	 */
	if ((runtime = index(date, ':')) == NULL){
		fprintf(stderr, "%s: Could not get the time correctly,\n", progname);
		diy();
		exit(1);
	}

	*(runtime+3) = '\0';
	runtime -= 2;
	


	/*
	 * System an at command to run the file at the right time.
	 * You need to use at -s since we are using a here document and
	 * csh (and its friends) won't like that.
	 *
	 */
	{char cmd[100];  /* Can't possibly be this long. */
		sprintf(cmd, "%s %s %s", AT, runtime, tmp);
		if (system(cmd)) {
			printf("%s: %s fails!\n", progname, cmd);
			diy();
		}
	}


	/*
	 * Get rid of the temporary.
	 *
	 */
	if (unlink(tmp) == -1) {
		printf("%s: Warning, could not remove %s\n", progname, tmp);
		exit(1);
	}

	return 0;
}

diy()
{
	/*
	 * Complain.
	 *
	 */
	fprintf(stderr, "Cannot arrange for automatic .rhosts removal!\n");
	fprintf(stderr, "Do it yourself.\n");
}

usage(me)
char *me;
{
	/*
	 * Complain bitterly.
	 *
	 */
	fprintf(stderr, "Usage: %s [-c] host user [minutes]\n", me);
	exit(1);
}
