The following are some programs which give you some familiar BSD utilities
in a System V environment.  The programs are:

	w	- Yes, "w", as big as life!  Requires...
	avenrun	- A program to be invoked in /etc/rc which computes
		  a "load average" from information in the "sysinfo"
		  structure of the kernel.  Based on a program by
		  Phil Budne which forges "rwhod" packets for mixed
		  networks; #define RWHOD for the original program.
	csl	- I have no idea what the BSD "sysline" does, but this
		  is my idea of a status line.  The name stands for
		  "cyclic status line"; it doesn't even attempt to
		  fit everything into one line, instead it cycles
		  through a set of "panels".  See the man page.
		  This also wants "avenrun" to be running.

Note that "w" (and ONLY "w") can be compiled for System III or Xenix 3.0;
this is in fact the default, use -DSYS5 to get the full version.

No Makefile; the compile commands are trivial:

	cc -O -o w w.c -DSYS5		# omit the -DSYS5 for System III
	cc -O -o avenrun avenrun.c	# add -DRWHOD for rwhod forgery
	cc -O -o csl csl.c

"w" requires read permission on /dev/kmem, /dev/mem, and /dev/swap.  "avenrun"
requires read permission on /dev/kmem (to read the sysinfo structure).  "csl"
can run as a normal user program.  On tdi2 we keep /dev/*mem and /dev/swap
-r--r----- root/sys and have "avenrun" and "w" setgid sys.

If someone wants to tell me what "sysline" under BSD does, I'd be interested
in writing a real one.  But "csl" is everything in one small package, so I
will probably continue to use it.

Enjoy!

++Brando
