/*
 * %W% %E% %U% ncoast!bsa %Z%
 * %Z% Copyright (C) 1985 by Brandon S. Allbery, All Rights Reserved %Z%
 */

#ifndef lint
static char _SccsId[] = "%W% %E% %U% ncoast!bsa %Z%";
static char _CopyRt[] = "%Z% Copyright (C) 1985 by Brandon S. Allbery %Z%";
#endif  lint

#include <stdio.h>
#include <time.h>
#include <signal.h>
#include <a.out.h>
#ifdef SYS5
#include <sys/types.h>
#endif
#include <sys/param.h>
#include <sys/var.h>
#include <sys/proc.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/stat.h>
#ifdef SYS5
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sysmacros.h>
#endif
#include <utmp.h>

#define UTMP		"/etc/utmp"
#ifndef KERNEL
#define KERNEL		"/unix"
#endif
#define KMEM		"/dev/kmem"
#define PMEM		"/dev/mem"
#define SMEM		"/dev/swap"

#define MIN		(60)
#define HOUR		(MIN * 60)
#define DAY		(HOUR * 24)
#define WEEK		(DAY * 7)
#define MONTH		(DAY * 30)

FILE *kfd;
FILE *mfd;
FILE *sfd;
FILE *utmp;
long nproc;
char _SObuf[BUFSIZ];
daddr_t swplo;
short mypid;

struct nlist kernel[] = {
	{"_v"},
	{"_proc"},
	{"_swplo"},
	{NULL},
};

char *months[] = {
	"Jan", "Feb", "Mar", "Apr", "May", "Jun",
	"Jul", "Aug", "Sep", "Oct", "Nov", "Dec",
};

struct tm *localtime();
char *vtime();
char *uptime();
char *itoa();

main() {
	struct utmp user;
	short ucnt;
	long now;
	struct var vars;
#ifdef SYS5
	int shm_id;
	key_t shm_k;
	double *avenrun;
#endif
	
	setbuf(stdout, _SObuf);
	mypid = getpid();
	time(&now);
	if (nlist(KERNEL, kernel) == -1) {
		perror(KERNEL);
		exit(2);
	}
	if ((utmp = fopen(UTMP, "r")) == NULL) {
		perror(UTMP);
		exit(1);
	}
	ucnt = 0;
	while (fread(&user, sizeof user, 1, utmp) > 0) {
#ifdef SYS5
		if (user.ut_type != USER_PROCESS)
#else
		if (user.ut_name[0] == '\0')
#endif
			continue;
		ucnt++;
	}
	if (kfd == NULL) {
		if ((kfd = fopen(KMEM, "r")) == NULL) {
			perror(KMEM);
			exit(3);
		}
	}
	fseek(kfd, kernel[0].n_value, 0);
	fread(&vars, sizeof vars, 1, kfd);
	nproc = vars.v_proc;
	fseek(kfd, kernel[2].n_value, 0);
	fread(&swplo, sizeof swplo, 1, kfd);
	if (mfd == NULL) {
		if ((mfd = fopen(PMEM, "r")) == NULL) {
			perror(PMEM);
			exit(4);
		}
	}
	if (sfd == NULL) {
		if ((sfd = fopen(SMEM, "r")) == NULL) {
			perror(SMEM);
			exit(5);
		}
	}
#ifdef SYS5
	if ((shm_k = ftok(KERNEL, 'a')) == (key_t) -1) {
		perror(KERNEL);
		exit(2);
	}
	if ((shm_id = shmget(shm_k, 3 * sizeof *avenrun, 0644)) < 0) {
		perror("shmget()");
		exit(2);
	}
	if ((int) (avenrun = (double *) shmat(shm_id, (char *) 0, SHM_RDONLY)) == -1) {
		perror("shmat()");
		exit(2);
	}
	printf(" %s  up%s,  %d users,  load average: %.1f, %.1f, %.1f\nUser     tty       login@  idle   JCPU   PCPU what\n", vtime(&now), uptime(), ucnt, avenrun[0], avenrun[1], avenrun[2]);
	if (shmdt((char *) avenrun) == -1) {
		perror("shmdt()");
		exit(2);
	}
#else
	printf(" %s  up%s,  %d users,  load average: not available under sys3\nUser     tty       login@  idle   JCPU   PCPU what\n", vtime(&now), uptime(), ucnt);
#endif
	rewind(utmp);
	while (fread(&user, sizeof user, 1, utmp) > 0) {
#ifdef SYS5
		if (user.ut_type != USER_PROCESS)
#else
		if (user.ut_name[0] == '\0')
#endif
			continue;
		show(&user);
	}
	fclose(utmp);
	exit(0);
}

char *uptime() {
	static char timebuf[128];
#ifdef SYS5
	struct utmp bootdata;
#else
	struct proc swapper;
	struct user bootproc;
#endif
	long oldpos, now;
	short cnt, ocnt;
	
#ifdef SYS5
	oldpos = fseek(utmp, 0L, 0);
	do {
		fread(&bootdata, sizeof bootdata, 1, utmp);
	} while (bootdata.ut_type != BOOT_TIME);
	fseek(utmp, oldpos, 0);
#else
	oldpos = fseek(kfd, 0L, 1);
	fseek(kfd, kernel[1].n_value, 0);
	fread(&swapper, sizeof swapper, 1, kfd);
	fseek(kfd, oldpos, 0);
	oldpos = fseek(mfd, 0L, 1);
	fseek(mfd, ctob(swapper.p_addr), 0);
	fread(&bootproc, sizeof bootproc, 1, mfd);
	fseek(mfd, 0L, 1);
#endif
	time(&now);
#ifdef SYS5
	now -= bootdata.ut_time;
#else
	now -= bootproc.u_start;
#endif
	if (now < 0L)
		return " with strange clock time";
	timebuf[0] = '\0';
	ocnt = 0;
	cnt = 0;
	while (now >= MONTH) {
		cnt++;
		now -= MONTH;
	}
	if (cnt > 0) {
		strcat(timebuf, itoa(cnt));
		strcat(timebuf, " mon");
		if (cnt > 1)
			strcat(timebuf, "s");
		if (++ocnt == 2)
			return timebuf;
	}
	cnt = 0;
	while (now >= WEEK) {
		cnt++;
		now -= WEEK;
	}
	if (cnt > 0) {
		strcat(timebuf, itoa(cnt));
		strcat(timebuf, " wk");
		if (cnt > 1)
			strcat(timebuf, "s");
		if (++ocnt == 2)
			return timebuf;
	}
	cnt = 0;
	while (now >= DAY) {
		cnt++;
		now -= DAY;
	}
	if (cnt > 0) {
		strcat(timebuf, itoa(cnt));
		strcat(timebuf, " day");
		if (cnt > 1)
			strcat(timebuf, "s");
		if (++ocnt == 2)
			return timebuf;
	}
	cnt = 0;
	while (now >= HOUR) {
		cnt++;
		now -= HOUR;
	}
	if (cnt > 0) {
		strcat(timebuf, itoa(cnt));
		strcat(timebuf, " hr");
		if (cnt > 1)
			strcat(timebuf, "s");
	}
	return timebuf;
}

char *itoa(n)
int n; {
	static char buf[20];
	
	sprintf(buf, " %d", n);
	return buf;
}

show(uinfo)
struct utmp *uinfo; {
	struct stat sbuf;
	struct proc proc;
	struct user prog;
	char ttydev[16];
	long now, cnt, offset, jcpu;
	short mpid, isswap;
	FILE *ufd;
	
	strcpy(ttydev, "/dev/");
	strncpy(&ttydev[5], uinfo->ut_line, 8);
	ttydev[13] = '\0';
	if (stat(ttydev, &sbuf) != 0) {
		perror(ttydev);
		return;
	}
	time(&now);
	now -= sbuf.st_atime;
	printf("%-8.8s %-8.8s %7s ", uinfo->ut_name, uinfo->ut_line, vtime(&uinfo->ut_time));
	if (now > DAY)
		printf("%4dd", now / DAY);
	else if (now > HOUR)
		printf("%2d:%02d", now / HOUR, (now % HOUR) / 60);
	else if (now > MIN)
		printf("%5d", now / MIN);
	else
		printf("     ");
	putchar(' ');
	fseek(kfd, kernel[1].n_value, 0);
	mpid = -1;
	jcpu = 0;
	for (cnt = 0; cnt < nproc; cnt++) {
		fread(&proc, sizeof proc, 1, kfd);
		if (proc.p_stat == 0 || proc.p_stat == SZOMB || proc.p_stat == SWAIT)
			continue;
		if (proc.p_flag & SLOAD) {
			fseek(mfd, ctob(proc.p_addr), 0);
			fread(&prog, sizeof prog, 1, mfd);
			isswap = 0;
		}
		else {
#ifdef SYS5
			fseek(sfd, (swplo + proc.p_swaddr + ctod(proc.p_swsize) - ctod(USIZE)) << 9, 0);
#else
			fseek(sfd, (long) (swplo + proc.p_addr) << 9, 0);
#endif
			fread(&prog, sizeof prog, 1, sfd);
			isswap = 1;
		}
		if (prog.u_ttyp == NULL)
			continue;
		if (sbuf.st_rdev != prog.u_ttyd)
			continue;
		jcpu += prog.u_utime + prog.u_stime;
		if (proc.p_pid == mypid)
			continue;
		if (proc.p_pid > mpid)
			mpid = proc.p_pid;
	}
	if (mpid == -1)
		printf("[can't stat]");
	else {
		fseek(kfd, kernel[1].n_value, 0);
		for (cnt = 0; cnt < nproc; cnt++) {
			fread(&proc, sizeof proc, 1, kfd);
			if (proc.p_pid == mpid)
				break;
		}
		if (proc.p_pid != mpid)
			printf("[interstice]");
		else {
			if (proc.p_flag & SLOAD) {
				fseek(mfd, ctob(proc.p_addr), 0);
				fread(&prog, sizeof prog, 1, mfd);
			}
			else {
#ifdef SYS5
				fseek(sfd, (swplo + proc.p_swaddr + ctod(proc.p_swsize) - ctod(USIZE)) << 9, 0);
#else
				fseek(sfd, (long) (swplo + proc.p_addr) << 9, 0);
#endif
				fread(&prog, sizeof prog, 1, sfd);
			}
			printf("%3d:%02d %3d:%02d ", jcpu / MIN, jcpu % MIN, (prog.u_utime + prog.u_stime) / MIN, (prog.u_utime + prog.u_stime) % MIN);
			prog.u_procp = &proc;
			pcmd(&prog);
		}
	}
	putchar('\n');
}

char *vtime(when)
long *when; {
	struct tm then, now;
	static char buf[20];
	short hour, min, ampm;
	long clock;

	time(&clock);
	now = *localtime(&clock);
	then = *localtime(when);
	if (then.tm_mon != now.tm_mon || then.tm_mday != now.tm_mday) {
		sprintf(buf, "%s %2d", months[then.tm_mon], then.tm_mday);
		return buf;
	}
	min = then.tm_min;
	if (then.tm_hour == 0) {
		ampm = 'a';
		hour = 12;
	}
	else if (then.tm_hour > 0 && then.tm_hour < 12) {
		ampm = 'a';
		hour = then.tm_hour;
	}
	else if (then.tm_hour == 12) {
		ampm = 'p';
		hour = 12;
	}
	else {
		ampm = 'p';
		hour = then.tm_hour - 12;
	}
	sprintf(buf, "%d:%02d%cm", hour, min, ampm);
	return buf;
}

pcmd(uinfo)
struct user *uinfo; {
	/* someday look up the user's command line */
	printf("%-.14s", uinfo->u_comm);
}
