#include <curses.h>
#include <a.out.h>
#include <term.h>
#include <time.h>
#include <fcntl.h>
#include <varargs.h>
#include <pwd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/param.h>
#include <sys/dir.h>
#include <sys/proc.h>
#include <sys/user.h>
#include <sys/var.h>
#include <sys/inode.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/sysmacros.h>
#include <utmp.h>

#define DISPLAY		5	/* seconds between panels */

char SObuf[BUFSIZ], lock[1024], messages[1024], fullname[64], logname[64];
double *avenrun;
int kmem, nproc, mem, swap, mail;
daddr_t swplo;

extern char *getenv(), *curcmd(), *ttyname(), *strrchr(), *itoa(), *fname(), *strchr();
extern int cleanup();
extern void setpwent();
extern struct passwd *getpwnam();
extern long time();
extern void setutent();
extern struct utmp *getutent();

struct nlist k[] = {
	{"_proc"},
	{"_v"},
	{"_swplo"},	
	{0},
};

char *weekday[] = {
	"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat",
};

main() {
	int cnt, nmsg, avend_id, aprogs, panel;
	char *cp, *cmd;
	key_t avend_k;
	struct tm *now;
	long instant;
	char msg[1024], subj[1024], from[128], mailf[128];
	char *fp, *bp, *logtty;
	struct utmp *user;
	
	setupterm((char *) 0, fileno(stdout), (int *) 0);
	if (!has_status_line) {
		fprintf(stderr, "csl: terminal doesn't have a status line\n");
		exit(1);
	}
	switch (fork()) {
	case 0:
		break;
	case -1:
		perror("csl");
		exit(1);
	default:
		exit(0);
	}
	signal(SIGINT, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
	signal(SIGHUP, cleanup);
	freopen("/dev/null", "r", stdin);
	if (nlist("/unix", k) != 0) {
		perror("/unix");
		exit(2);
	}
	if ((kmem = open("/dev/kmem", O_RDONLY)) == -1) {
		perror("/dev/kmem");
		exit(1);
	}
	if ((mem = open("/dev/mem", O_RDONLY)) == -1) {
		perror("/dev/mem");
		exit(1);
	}
	if ((swap = open("/dev/swap", O_RDONLY)) == -1) {
		perror("/dev/swap");
		exit(1);
	}
	if ((cp = getenv("LOGNAME")) == (char *) 0)
		strcpy(logname, "daemon");
	else
		strcpy(logname, cp);
	fname(fullname);
	getnproc();
	if ((cp = getenv("HOME")) == (char *) 0) {
 		strcpy(lock, "./.syslinelock");
		strcpy(messages, "./.messages");
	}
	else {
		sprintf(lock, "%s/.syslinelock", cp);
		sprintf(messages, "%s/.messages", cp);
	}
	setbuf(stdout, SObuf);
	if ((avend_k = ftok("/unix", 'a')) == (key_t) -1) {
		perror("/unix");
		exit(1);
	}
	if ((avend_id = shmget(avend_k, 3 * sizeof (double), 0644)) < 0)
		avenrun = (double *) 0;
	else if ((int) (avenrun = (double *) shmat(avend_id, (char *) 0, SHM_RDONLY)) == -1) {
		perror("shmat");
		exit(1);
	}
	lseek(kmem, k[3].n_value, 0);
	read(kmem, &swplo, sizeof swplo);
	logtty = strrchr(ttyname(fileno(stdout)), '/') + 1;
	sprintf(mailf, "/usr/mail/%s", logname);
	for (;;) {
		if (access(lock, 0) == 0) {
			putp(dis_status_line);
			fflush(stdout);
			while (access(lock, 0) == 0)
				sleep(30);
		}
		panel = 1;
		from[0] = '\0';
		subj[0] = '\0';
		if ((mail = open(mailf, O_RDONLY)) == -1)
			nmsg = 0;
		else {
			cnt = 0;
			while (rgets(mail, msg, sizeof msg) != -1) {
				if (strncmp(msg, "From ", 5) == 0) {
					int mcnt;

					if (from[0] != '\0')
						showpanel(panel++, "New mail from %s: %s", from, (subj[0]? subj: "[No subject]"));
					subj[0] = '\0';
					cnt++;
					for (mcnt = 5; msg[mcnt] != '\0'; mcnt++)
						if (msg[mcnt] == ' ')
							break;
					msg[mcnt++] = '\0';
					if ((fp = strrchr(msg + 5, '!')) == (char *) 0)
						strcpy(from, msg + 5);
					else {
						*fp = '\0';
						if ((bp = strrchr(msg + 5, '!')) == (char *) 0)
						bp = msg + 5;
						*fp = '!';
						strcpy(from, bp);
					}
					subj[0] = '\0';
				}
				else if (strncmp(msg, "Subject: ", 9) == 0)
					strcpy(subj, msg + 9);
			}
			close(mail);
			if (from[0] != '\0')
				showpanel(panel++, "New mail from %s: %s", from, (subj[0]? subj: "[No subject]"));
			nmsg = cnt;
		}
		cmd = curcmd(&aprogs);
		time(&instant);
		now = localtime(&instant);
		if (avenrun != (double *) 0)
			showpanel(panel++, " %s // %s // %4.2f %4.2f %4.2f // %s msgs // %3s %02d/%02d %02d:%02d ", cmd, logname, avenrun[0], avenrun[1], avenrun[2], (nmsg == 0? "No": itoa(nmsg)), weekday[now->tm_wday], now->tm_mon + 1, now->tm_mday, now->tm_hour, now->tm_min);
		else
			showpanel(panel++, " %s // %s // %s msgs // %3s %02d/%02d %02d:%02d //", cmd, logname, (nmsg == 0? "No": itoa(nmsg)), weekday[now->tm_wday], now->tm_mon + 1, now->tm_mday, now->tm_hour, now->tm_min);
		showpanel(panel++, " ``%s'' on %s // %d active programs", fullname, logtty, aprogs);
		if ((mail = open(messages, O_RDONLY)) != -1) {
			while (rgets(mail, msg, sizeof msg) != -1)
				showpanel(panel++, "%s", msg);
			close(mail);
		}
		setutent();
		cnt = 0;
		msg[0] = '\0';
		while ((user = getutent()) != (struct utmp *) 0) {
			if (user->ut_type != USER_PROCESS)
				continue;
			sprintf(subj, "%.8s", user->ut_user);
			if (msg[0] != '\0')
				strcat(msg, ", ");
			strcat(msg, subj);
			cnt++;
		}
		showpanel(panel++, " %d users: %s", cnt, msg);
	}
}

cleanup() {
	if (avenrun != (double *) 0 && shmdt(avenrun) < 0) {
		perror("shmdt");
		exit(1);
	}
	reset_shell_mode();
	exit(0);
}

getnproc() {
	struct var v;

	lseek(kmem, k[1].n_value, 0);
	read(kmem, &v, sizeof v);
	nproc = v.v_proc;
}

char *curcmd(progp)
int *progp; {
	struct proc p;
	struct user cmd;
	struct file f;
	struct inode i;
	static struct stat idev;
	static int pgrp, mypid;
	static char cmdname[DIRSIZ + 1];
	long stime;
	int cnt;
	static int didit = 0;
	
	if (didit == 0) {
		stat("/dev/null", &idev);
		pgrp = getpgrp();
		mypid = getpid();
		didit = 1;
	}
	*progp = 0;
	stime = 0L;
	strcpy(cmdname, "???");
	lseek(kmem, k[0].n_value, 0);
	for (cnt = 0; cnt < nproc; cnt++) {
		read(kmem, &p, sizeof p);
		if (p.p_stat != SRUN && p.p_stat != SSLEEP)
			continue;
		if (p.p_pid == mypid)
			continue;
		if (p.p_pgrp != pgrp)
			continue;
		if (p.p_stat == SSLEEP && (long) p.p_wchan >= k[0].n_value && (long) p.p_wchan < k[0].n_value + nproc * sizeof p)
			continue;	/* sleeping on a child */
		(*progp)++;
		if (p.p_flag & SLOAD) {
			lseek(mem, (long) (NBPC * p.p_addr), 0);
			read(mem, &cmd, sizeof cmd);
		}
		else {
			lseek(swap, (swplo + p.p_swaddr + ctod(p.p_swsize) - ctod(USIZE)) << 9, 0);
			read(swap, &cmd, sizeof cmd);
		}
		if (cmd.u_ttyp == 0)
			continue;
/* AAUGH!  USG VAR csh'es close stdin!!!  That's absolutely insane!!!
 *		if (p.p_pid != p.p_ppid && cmd.u_ofile[0] == 0)
 *			continue;
 */
		if (cmd.u_ofile[0] != 0) {
			lseek(kmem, cmd.u_ofile[0], 0);
			read(kmem, &f, sizeof f);
			lseek(kmem, f.f_inode, 0);
			read(kmem, &i, sizeof i);
			lseek(kmem, k[0].n_value + cnt * sizeof p, 0);
			if (i.i_dev == idev.st_dev && i.i_number == idev.st_ino && cmd.u_signal[SIGINT] == (long) SIG_IGN)
				continue;	/* ignore background processes */
		}
		if (cmd.u_start < stime)
			continue;
		stime = cmd.u_start;
		strncpy(cmdname, cmd.u_comm, DIRSIZ);
	}
	return cmdname;
}

rgets(fd, buf, maxlen)
char *buf;
unsigned maxlen; {
	unsigned cnt;
	
	*buf = '\0';
	for (cnt = 0; cnt < maxlen - 1 && read(fd, buf, 1) > 0 && *buf != '\n'; cnt++, buf++)
		;
	if (cnt == 0 && *buf != '\n')
		return -1;
	*buf = '\0';
	return cnt;
}

char *itoa(n) {
	static char ibuf[20];
	
	sprintf(ibuf, "%d", n);
	return ibuf;
}

/* Does the lint declaration below actually *do* anything? */
/*VARARGS PRINTFLIKE2*/
showpanel(va_alist)
va_dcl {
	va_list args;
	int panel, cnt;
	static char buf[5120];
	register char *cp;

	va_start(args);
	panel = va_arg(args, int);
	cp = va_arg(args, char *);
	sprintf(buf, "%2.2d>", panel);
	vsprintf(buf + 3, cp, args);
	putp(tparm(to_status_line, 0));
	for (cp = buf, cnt = 0; cnt < width_status_line && *cp != '\0'; cp++, cnt++)
		putchar(*cp);
	while (cnt++ < width_status_line)
		putchar(' ');
	putp(from_status_line);
	fflush(stdout);
	sleep(DISPLAY);
}

/*
 * If you use RJE fullnames :0000-Foo Z. Bar(0000):, change this.
 * If you aren't running RJE, why bother with it?
 */

char *fname(buf)
char *buf; {
	static char fbuf[128];
	struct passwd *me;
	char *cp;

	setpwent();
	me = getpwnam(logname);
	endpwent();
	if (me == (struct passwd *) 0)
		strcpy(fbuf, logname);
	else {
		strcpy(fbuf, me->pw_gecos);
		if ((cp = strchr(fbuf, ',')) != (char *) 0)
			*cp = '\0';
	}
	if (buf == (char *) 0)
		return fbuf;
	strcpy(buf, fbuf);
	return buf;
}
