#ifndef lint
static char *RCSid = "$Header$";
#endif

/*
 * namelist.c - routines for manipulating the name list structures
 *
 * David A. Curry
 * Purdue University
 * Engineering Computer Network
 * October, 1986
 *
 * $Log$
 */
#include <syslog.h>
#include <stdio.h>
#include "defs.h"

extern int npw;
extern char *pwbuf;
extern struct listhead *groups;

/*
 * dofunction - take a config file function and return the namelist it
 *		produces
 */
struct namelist *dofunction(func, arg)
int func;
register char *arg;
{
	register int i;
	char buf[PWSIZE];
	struct listhead *lookuplh();
	register struct listhead *lh;
	struct namelist *makenl(), *copynl();
	register struct namelist *nl, *nlbase;

	/*
	 * See what function we're doing.
	 */
	switch (func) {
	case FUN_GROUP:			/* return group			*/
		/*
		 * Look up the group.
		 */
		if ((lh = lookuplh(groups, arg)) == NULL)
			return(NULL);

		/*
		 * Return a copy of the namelist of members.  We
		 * have to return a copy since they may add on to
		 * the end of it.
		 */
		return(copynl(lh->lh_namelist));
	case FUN_CLASS:			/* return classification	*/
		nlbase = NULL;

		/*
		 * Run through the password "file" (pwbuf) and build a
		 * namelist of all people whose classification is the
		 * same as arg.
		 */
		for (i=0; i < npw; i++) {
			/*
			 * Not the same class, skip it.
			 */
			if (pwbuf[(i+1) * PWSIZE - 1] != *arg)
				continue;

			/*
			 * Save the login name.
			 */
			strncpy(buf, &pwbuf[i * PWSIZE], PWSIZE - 2);
			buf[PWSIZE - 2] = NULL;

			/*
			 * Add an element.
			 */
			if (nlbase == NULL) {
				nlbase = makenl(savestr(buf));
				nl = nlbase;
			}
			else {
				nl->nl_next = makenl(savestr(buf));
				nl = nl->nl_next;
			}
		}

		if (nl)
			nl->nl_next = NULL;

		return(nlbase);
	case FUN_SCHOOL:		/* return department		*/
		nlbase = NULL;

		/*
		 * Run through the password "file" (pwbuf) and build
		 * a namelist of all names which have arg as their
		 * department.
		 */
		for (i=0; i < npw; i++) {
			/*
			 * Not this department, skip it.
			 */
			if (pwbuf[(i+1) * PWSIZE - 2] != *arg)
				continue;

			/*
			 * Save the login name.
			 */
			strncpy(buf, &pwbuf[i * PWSIZE], PWSIZE - 2);
			buf[PWSIZE - 2] = NULL;

			/*
			 * Add an entry.
			 */
			if (nlbase == NULL) {
				nlbase = makenl(savestr(buf));
				nl = nlbase;
			}
			else {
				nl->nl_next = makenl(savestr(buf));
				nl = nl->nl_next;
			}
		}

		if (nl)
			nl->nl_next = NULL;

		return(nlbase);
	}
}

/*
 * makenl - allocate a namelist structure and stick the string into it
 */
struct namelist *makenl(s)
register char *s;
{
	register struct namelist *nl;

	if ((nl = (struct namelist *) malloc(sizeof(struct namelist))) == NULL) {
		message("ran out of memory in makenl - exiting\n", 0, 0);
		syslog(LOG_ERR, "ran out of memory in makenl.");
		exit(1);
	}

	nl->nl_next = NULL;
	nl->nl_name = s;
	return(nl);
}

/*
 * copynl - make a copy of a namelist and return it
 */
struct namelist *copynl(oldnl)
register struct namelist *oldnl;
{
	struct namelist *makenl();
	register struct namelist *nl, *newnl;

	newnl = NULL;

	for ( ; oldnl != NULL; oldnl = oldnl->nl_next) {
		if (newnl == NULL) {
			newnl = makenl(oldnl->nl_name);
			nl = newnl;
		}
		else {
			nl->nl_next = makenl(oldnl->nl_name);
			nl = nl->nl_next;
		}
	}

	if (nl)
		nl->nl_next = NULL;

	return(newnl);
}

/*
 * lookuplh - look up a listhead structure whose listname is s.
 */
struct listhead *lookuplh(lh, s)
register struct listhead *lh;
register char *s;
{
	for ( ; lh != NULL; lh = lh->lh_next) {
		if (!strcmp(lh->lh_listname, s))
			return(lh);
	}

	return(NULL);
}

/*
 * lookupnl - look up a namelist element which contains s.
 */
struct namelist *lookupnl(nl, s)
register struct namelist *nl;
register char *s;
{
	for ( ; nl != NULL; nl = nl->nl_next) {
		if (!strcmp(nl->nl_name, s))
			return(nl);
	}

	return(NULL);
}
