#ifndef lint
static char *RCSid = "$Header$";
#endif

/*
 * main.c - main program - handles argument parsing, controls flow
 *	    of program
 *
 * David A. Curry
 * Purdue University
 * Engineering Computer Network
 * October, 1986
 *
 * $Log$
 */
#include <sys/param.h>
#include <sys/ioctl.h>
#include <sys/file.h>
#include <signal.h>
#include <syslog.h>
#include <stdio.h>
#include "defs.h"

FILE *logfp = NULL;			/* log file pointer		*/
char *logfile = DEF_LOGFILE;		/* log file path name		*/
char *configfile = DEF_CONFIGFILE;	/* config file path name	*/

char *pname;				/* program name			*/
int logging = 0;			/* 1 if log messages are on	*/
int tracing = 0;			/* 1 if trace messages are on	*/

main(argc, argv)
int argc;
char **argv;
{
	register int i;
	extern int reinitialize();

#ifndef DEBUG
	/*
	 * Detach from the parent.
	 */
	if (fork())
		exit(0);

	/*
	 * Zap process group.
	 */
	setpgrp(0, 0);

	/*
	 * Close files.
	 */
	for (i=0; i < NOFILE; i++)
		close(i);

	/*
	 * Ignore signals.
	 */
	for (i=0; i < NSIG; i++)
		signal(i, SIG_IGN);

	signal(SIGTERM, SIG_DFL);

	open("/dev/null", O_RDONLY);
	open("/dev/null", O_WRONLY);
	dup(1);

	/*
	 * Clear controlling tty.
	 */
	if ((i = open("/dev/tty", O_RDWR)) > 0) {
		ioctl(i, TIOCNOTTY, 0);
		close(i);
	}
#endif

	/*
	 * Open syslog.  If this fails, the stupid thing opens
	 * /dev/console, which unclears our clearing of the
	 * controlling tty.  Yay for undocumented misfeatures.
	 */
	pname = *argv;
	openlog(pname, LOG_PID, 0);

	/*
	 * Parse the arguments...
	 */
	while (--argc) {
		if (**++argv != '-')
			usage(pname);

		switch (*++*argv) {
		case 'f':		/* alternate config file	*/
			if (--argc <= 0)
				usage(pname);

			configfile = *++argv;
			break;
		case 'l':		/* alternate log file		*/
			if (--argc <= 0)
				usage(pname);

			logfile = *++argv;
			logging = 1;
			break;
		case 't':		/* turn on tracing to log file	*/
			tracing = 1;
			break;
		case 'v':		/* turn on logging to def log	*/
			logging = 1;
			break;
		default:
			usage(pname);
			break;
		}
	}

	/*
	 * If logging is on, open the log file.
	 */
	if (logging) {
		if ((logfp = fopen(logfile, "a")) == NULL) {
			syslog(LOG_ERR, "cannot open \"%s\" for writing.", logfile);
			logging = 0;
		}

		message("-------- new spot started, pid = %d --------\n", getpid(), 0);
	}

	/*
	 * Initialize data structures.
	 */
	initialize();

	/*
	 * Now SIGHUP can make us reinitialize.
	 */
	signal(SIGHUP, reinitialize);

	/*
	 * Be a watchdog.  There's no return from this.
	 */
	watchdog();
}
