#ifndef lint
static char *RCSid = "$Header$";
#endif

/*
 * init.c - initialize data structures, read configuration file, etc.
 *
 * David A. Curry
 * Purdue University
 * Engineering Computer Network
 * October, 1986
 *
 * $Log$
 */
#include <sys/types.h>
#include <sys/file.h>
#include <syslog.h>
#include <signal.h>
#include <stdio.h>
#include <utmp.h>
#include "defs.h"
#include <pwd.h>
#include <grp.h>
#include <ecngecos.h>

int npw = 0;				/* number of pwbuf entries	*/
char *pwbuf = NULL;			/* password file names		*/

int ud = -1;				/* utmp file descriptor		*/
struct utmp *utmp = NULL;		/* utmp structures		*/

int maxusers = DEF_MAXUSERS;
int cycletime = DEF_CYCLETIME;
int graceperiod = DEF_GRACEPERIOD;

char *deny_msg = DEF_DENYMSG;
char *freeup_msg = DEF_FREEUPMSG;
char *killidle_msg = DEF_KILLIDLEMSG;
char *killmulti_msg = DEF_KILLMULTIMSG;
char *killsession_msg = DEF_KILLSESSIONMSG;

struct denial *deny = NULL;
struct listhead *groups = NULL;
struct listhead *commands = NULL;
struct listhead *namelists = NULL;
struct listhead *exemptions = NULL;

int nvictims = 0;			/* number of victims in victims	*/
struct victim *victims = NULL;		/* victims structures		*/

/*
 * initialize - initialize data structures, allocate memory, etc.
 */
initialize()
{
	trace("initialize()\n", 0, 0);

	/*
	 * Load in the password and group files so we don't have
	 * to constantly access them.
	 */
	loadpwfile();
	loadgroupfile();

	/*
	 * Allocate the utmp structures.
	 */
	if ((utmp = (struct utmp *) malloc(maxusers * sizeof(struct utmp))) == NULL) {
		message("ran out of memory allocating utmp structures - exiting.\n", 0, 0);
		syslog(LOG_ERR, "ran out of memory allocating utmp structures.");
		exit(1);
	}

	/*
	 * Open up utmp.
	 */
	if ((ud = open(UTMPFILE, O_RDONLY)) < 0) {
		message("cannot open \"%s\" for reading - exiting.\n", UTMPFILE, 0);
		syslog(LOG_ERR, "cannot open \"%s\" for reading (%m).", UTMPFILE);
		exit(1);
	}

	/*
	 * Read in the config file.
	 */
	trace("calling yyparse()...\n", 0, 0);
	yyparse();
	trace("done.\n", 0, 0);
}

/*
 * loadpwfile - load in the password file saving login name, school,
 *		and classification.
 */
loadpwfile()
{
	extern int pwcmp();
	register int pwsize;
	struct passwd *getpwent();
	register struct passwd *pw;
	register struct ecngecos *eg;
	struct ecngecos *getecngecos();

	trace("loadpwfile()\n", 0, 0);
	setpwent();

	/*
	 * While there's entries...
	 */
	while ((pw = getpwent()) != NULL) {
		/*
		 * First time through... allocate stuff.
		 */
		if (pwbuf == NULL) {
			pwsize = 100;
			npw = 0;

			if ((pwbuf = (char *) malloc(pwsize * PWSIZE)) == NULL) {
				message("ran out of memory allocating pwbuf - exiting.\n", 0, 0);
				syslog(LOG_ERR, "ran out of memory allocating pwbuf.");
				exit(1);
			}
		}

		/*
		 * Not enough room, reallocate.
		 */
		if (npw == pwsize) {
			pwsize *= 2;

			if ((pwbuf = (char *) realloc(pwbuf, pwsize * PWSIZE)) == NULL) {
				message("ran out of memory allocating pwbuf - exiting.\n", 0, 0);
				syslog(LOG_ERR, "ran out of memory allocating pwbuf.");
				exit(1);
			}
		}

		/*
		 * Save the login name.
		 */
		strcpy(&pwbuf[npw++ * PWSIZE], pw->pw_name);

		/*
		 * Save department and classification.
		 */
		if ((eg = getecngecos(pw)) != NULL) {
			pwbuf[npw * PWSIZE - 2] = eg->eg_deptcode;
			pwbuf[npw * PWSIZE - 1] = eg->eg_classification;
		}
	}

	endpwent();

	/*
	 * Sort it.
	 */
	qsort(pwbuf, npw, PWSIZE, pwcmp);
}

/*
 * loadgroupfile - load in the group file to make things run faster
 */
loadgroupfile()
{
	char *savestr();
	register char **cp;
	struct group *getgrent();
	struct namelist *makenl();
	register struct group *gr;
	register struct namelist *nl;
	register struct listhead *lh;

	trace("loadgroupfile()\n", 0, 0);
	setgrent();

	/*
	 * While there's entries...
	 */
	while ((gr = getgrent()) != NULL) {
		/*
		 * Allocate a list head.
		 */
		if (groups == NULL) {
			groups = (struct listhead *) malloc(sizeof(struct listhead));
			lh = groups;
		}
		else {
			lh->lh_next = (struct listhead *) malloc(sizeof(struct listhead));
			lh = lh->lh_next;
		}

		if (lh == NULL) {
			message("ran out of memory allocating groups list - exiting.\n", 0, 0);
			syslog(LOG_ERR, "ran out of memory allocating groups list.");
			exit(1);
		}

		lh->lh_next = NULL;
		lh->lh_namelist = NULL;
		lh->lh_listname = savestr(gr->gr_name);

		/*
		 * Save the members in the namelist.
		 */
		for (cp = gr->gr_mem; *cp; cp++) {
			if (lh->lh_namelist == NULL) {
				lh->lh_namelist = makenl(savestr(*cp));
				nl = lh->lh_namelist;
			}
			else {
				nl->nl_next = makenl(savestr(*cp));
				nl = nl->nl_next;
			}
		}

		if (nl)
			nl->nl_next = NULL;
	}

	endgrent();
}

/*
 * reinitialize - get rid of all allocated memory, go initialize again.
 */
reinitialize()
{
	register struct denial *dn;
	register struct listhead *lh;
	register struct namelist *nl;
	
	syslog(LOG_NOTICE, "reinitalizing.");
	message("reinitializing.\n", 0, 0);

	if (ud >= 0)
		close(ud);

	if (utmp != NULL)
		free(utmp);

	if (pwbuf != NULL)
		free(pwbuf);

	if (victims != NULL)
		free(victims);

	for (dn = deny; dn != NULL; dn = dn->dn_next) {
		for (nl = dn->dn_users; nl != NULL; nl = nl->nl_next)
			free(nl);
		for (nl = dn->dn_terminals; nl != NULL; nl = nl->nl_next)
			free(nl);
		free(dn);
	}

	deny = NULL;

	for (lh = groups; lh != NULL; lh = lh->lh_next) {
		for (nl = lh->lh_namelist; nl != NULL; nl = nl->nl_next)
			free(nl);
		free(lh->lh_listname);
		free(lh);
	}

	groups = NULL;

	for (lh = commands; lh != NULL; lh = lh->lh_next) {
		for (nl = lh->lh_namelist; nl != NULL; nl = nl->nl_next)
			free(nl);
		free(lh);
	}

	commands = NULL;

	for (lh = namelists; lh != NULL; lh = lh->lh_next) {
		for (nl = lh->lh_namelist; nl != NULL; nl = nl->nl_next)
			free(nl);
		free(lh->lh_listname);
		free(lh);
	}

	namelists = NULL;

	for (lh = exemptions; lh != NULL; lh = lh->lh_next) {
		for (nl = lh->lh_namelist; nl != NULL; nl = nl->nl_next)
			free(nl);
		free(lh);
	}

	exemptions = NULL;

	initialize();
}
