/*
 * $Header: /usr/harbor/davy/system/spot/RCS/defs.h,v 1.3 86/12/01 14:34:03 davy Exp $
 *
 * defs.h - definitions of constants and structures
 *
 * David A. Curry
 * Purdue University
 * Engineering Computer Network
 * October, 1986
 *
 * $Log:	defs.h,v $
 * Revision 1.3  86/12/01  14:34:03  davy
 * Changed declarations of structures to support "between" command.
 * 
 * Revision 1.2  86/12/01  10:21:32  davy
 * Changed "overloading" to "high terminal demand", which makes a little
 * more sense.
 * 
 * Revision 1.1  86/12/01  10:18:26  davy
 * Initial revision
 * 
 */

#define PWSIZE		(8+1+1)		/* size of a record in pwbuf	*/
#define UTMPFILE	"/etc/utmp"	/* path to the "who" file	*/
#define UTNAMESIZE	8		/* size of utmp.ut_name		*/
#define UTLINESIZE	8		/* size of utmp.ut_line		*/
#define UTHOSTSIZE	16		/* size of utmp.ut_host		*/
#define TERMINAL_LOGIN	"terminal"	/* special rlogin login name	*/

/*
 * Config file commands.
 */
#define CMD_DENY	001
#define CMD_FREEUP	002
#define CMD_KILLIDLE	004
#define CMD_TERMINAL	010
#define CMD_KILLMULTI	020
#define CMD_KILLSESSION	040

/*
 * Config file functions.
 */
#define FUN_GROUP	001
#define FUN_CLASS	002
#define FUN_SCHOOL	004

#define DEF_MAXUSERS	256		/* size of utmp			*/
#define DEF_CYCLETIME	10		/* cycle time in minutes	*/
#define DEF_GRACEPERIOD	3		/* grace period before logoff	*/

/*
 * Default configuration file and log file.
 */
#define DEF_LOGFILE	"/usr/local/lib/spot.log"
#define DEF_CONFIGFILE	"/usr/local/lib/spot.cf"

/*
 * Default messages for each type of kill.
 */
#define DEF_DENYMSG		"Access to this terminal denied."
#define DEF_FREEUPMSG		"Due to high terminal demand, users from other\r\nschools must log off."
#define DEF_KILLIDLEMSG		"Due to high terminal demand, users idle for more\r\nthan %d minutes must log off."
#define DEF_KILLMULTIMSG	"Due to high terminal demand, no more than %d\r\nsimultaneous logins are allowed."
#define DEF_KILLSESSIONMSG	"Maximum time limit of %d minutes exceeded."

/*
 * Head of a linked list.
 */
struct listhead {
	char	lh_command;		/* cmd if command or exemption 	*/
	int	lh_parameter;		/* parameter given if command 	*/
	char	*lh_listname;		/* name of list if namelist	*/

	int	lh_start;		/* time list goes into effect	*/
	int	lh_finish;		/* time list goes out of effect	*/

	struct namelist *lh_namelist;	/* namelist given for all types	*/
	struct listhead *lh_next;	/* pointer to next list head	*/
};

/*
 * For recording information about our potential victims.
 */
struct victim {
	char	vi_command;		/* command which is getting him	*/
	int	vi_parameter;		/* parameter to the command	*/
	char	vi_name[UTNAMESIZE+1];	/* his login name		*/

	struct utmp	*vi_utmp;	/* his utmp entry		*/
};

/*
 * Special structure for holding "deny" commands, which have
 * two namelists.
 */
struct denial {
	int	dn_start;		/* time deny goes into effect	*/
	int	dn_finish;		/* time deny goes out of effect	*/

	struct namelist *dn_users;	/* users who are denied		*/
	struct namelist *dn_terminals;	/* what they're denied from	*/

	struct denial	*dn_next;	/* pointer to next denial	*/
};

/*
 * List of names.
 */
struct namelist {
	char	*nl_name;		/* name of this element		*/
	struct namelist *nl_next;	/* pointer to next element	*/
};

