#ifndef lint
static char *RCSid = "$Header: /usr/harbor/davy/system/spot/RCS/util.c,v 1.3 86/12/01 14:34:31 davy Exp $";
#endif

/*
 * util.c - utility routines
 *
 * David A. Curry
 * Purdue University
 * Engineering Computer Network
 * October, 1986
 *
 * $Log:	util.c,v $
 * Revision 1.3  86/12/01  14:34:31  davy
 * Added code to support "between" command.
 * 
 * Revision 1.2  86/11/22  13:28:32  davy
 * Added an fseek to message() so that if the log file gets truncated
 * we don't keep writing out past the end of the file.
 * 
 * Revision 1.1  86/11/22  13:26:59  davy
 * Initial revision
 * 
 */
#include <sys/types.h>
#include <sys/time.h>
#include <syslog.h>
#include <stdio.h>
#include <utmp.h>
#include "defs.h"

/*
 * savestr - save a string in allocated memory.
 */
char *savestr(s)
register char *s;
{
	register char *t;

	if ((t = (char *) malloc(strlen(s) + 1)) == NULL) {
		message("ran out of memory in savestr - exiting.\n", 0, 0);
		syslog(LOG_ERR, "ran out of memory in savestr.");
		exit(1);
	}

	strcpy(t, s);
	return(t);
}

/*
 * addlist - add a listhead structure to the linked list of listhead
 *	     structures in list.  The other arguments are the pieces
 *	     of the listhead.
 */
addlist(list, cmd, param, name, nlist, tstart, tfinish)
int cmd, param, tstart, tfinish;
struct listhead **list;
struct namelist *nlist;
char *name;
{
	register struct listhead *lh;

	/*
	 * Allocate a new structure at the end of the linked list.
	 */
	if (*list == NULL) {
		*list = (struct listhead *) malloc(sizeof(struct listhead));
		lh = *list;
	}
	else {
		for (lh = *list; lh->lh_next != NULL; lh = lh->lh_next)
			;

		lh->lh_next = (struct listhead *) malloc(sizeof(struct listhead));
		lh = lh->lh_next;
	}

	if (lh == NULL) {
		message("ran out of memory in addlist - exiting.\n", 0, 0);
		syslog(LOG_ERR, "ran out of memory in addlist.");
		exit(1);
	}

	/*
	 * Fill in the stuff.
	 */
	lh->lh_next = NULL;
	lh->lh_command = cmd;
	lh->lh_start = tstart;
	lh->lh_listname = name;
	lh->lh_finish = tfinish;
	lh->lh_namelist = nlist;
	lh->lh_parameter = param;
}

/*
 * adddeny - like addlist, only for deny structures.
 */
adddeny(denylist, users, terminals, tstart, tfinish)
int tstart, tfinish;
struct denial **denylist;
struct namelist *users, *terminals;
{
	register struct denial *dn;

	/*
	 * Add a new structure at the end of the list.
	 */
	if (*denylist == NULL) {
		*denylist = (struct denial *) malloc(sizeof(struct denial));
		dn = *denylist;
	}
	else {
		for (dn = *denylist; dn->dn_next != NULL; dn = dn->dn_next)
			;

		dn->dn_next = (struct denial *) malloc(sizeof(struct denial));
		dn = dn->dn_next;
	}

	if (dn == NULL) {
		message("ran out of memory in adddeny - exiting.\n", 0, 0);
		syslog(LOG_ERR, "ran out of memory in adddeny.");
		exit(1);
	}

	/*
	 * Fill in the information.
	 */
	dn->dn_next = NULL;
	dn->dn_users = users;
	dn->dn_start = tstart;
	dn->dn_finish = tfinish;
	dn->dn_terminals = terminals;
}

/*
 * message - print a message to the log file
 */
message(fmt, arg1, arg2)
char *fmt, *arg1, *arg2;
{
	long clock;
	char *ctime();
	extern FILE *logfp;
	extern int logging;

	if (logging) {
		time(&clock);

		/*
		 * Seek to end of file first, in case it's been
		 * truncated and we're past the end.
		 */
		fseek(logfp, 0L, 2);

		fprintf(logfp, "%.16s ", ctime(&clock));
		fprintf(logfp, fmt, arg1, arg2);
		fflush(logfp);
	}
}

/*
 * trace - print a trace message to the log file
 */
trace(fmt, arg1, arg2)
char *fmt, *arg1, *arg2;
{
	char buf[BUFSIZ];
	extern int tracing;

	if (tracing) {
		sprintf(buf, "TRACE: %s", fmt);
		message(buf, arg1, arg2);
	}
}

/*
 * pwcmp - for sorting pwbuf by login name
 */
pwcmp(a, b)
register char *a, *b;
{
	return(strncmp(a, b, PWSIZE - 2));
}

/*
 * namecmp - for sorting utmp by login name - if same login, sort longest
 *	     logged in one first
 */
namecmp(a, b)
register struct utmp **a, **b;
{
	register int x;

	x = strncmp((*a)->ut_name, (*b)->ut_name, UTNAMESIZE);

	if (x == 0)
		return((*a)->ut_time - (*b)->ut_time);

	return(x);
}

/*
 * timecmp - for sorting utmp by login time - sort in decreasing order by
 *	     length of time logged in.
 */
timecmp(a, b)
register struct utmp **a, **b;
{
	if ((*a)->ut_name[0] == NULL) {
		if ((*b)->ut_name == NULL)
			return(0);
		return(1);
	}

	if ((*b)->ut_name[0] == NULL)
		return(-1);

	return((*a)->ut_time - (*b)->ut_time);
}

/*
 * gettime - return hours and minutes as a number, hhmm.
 */
gettime()
{
	long clock;
	struct tm *t, *localtime();

	time(&clock);
	t = localtime(&clock);

	return(t->tm_hour * 100 + t->tm_min);
}

/*
 * between - see if val is between para and parb
 */
between(val, para, parb)
int val, para, parb;
{
	if (para <= parb)
		return((val >= para) && (val <= parb));
	else
		return((val >= para) || (val <= parb));
}

usage(prog)
char *prog;
{
	syslog(LOG_ERR, "Usage: %s [-f configfile] [-l logfile] [-v]", prog);
	exit(1);
}

#ifdef DEBUG
printlists()
{
	int curtime;
	register struct denial *dn;
	register struct listhead *lh;
	register struct namelist *nl;
	extern struct denial *deny;
	extern struct listhead *groups;
	extern struct listhead *commands;
	extern struct listhead *namelists;
	extern struct listhead *exemptions;

	curtime = gettime();
	printf("CURTIME = %04d\n", curtime);

	for (lh = groups; lh != NULL; lh = lh->lh_next) {
		printf("\nGROUP %s\n\t", lh->lh_listname);
		printnl(lh->lh_namelist);
		printf("\n");
	}

	for (lh = commands; lh != NULL; lh = lh->lh_next) {
		printf("\nCOMMAND ", lh->lh_listname);

		switch (lh->lh_command) {
		case CMD_FREEUP:	printf("freeup"); break;
		case CMD_KILLIDLE:	printf("killidle"); break;
		case CMD_KILLMULTI:	printf("killmulti"); break;
		case CMD_KILLSESSION:	printf("killsession"); break;
		}

		if (!between(curtime, lh->lh_start, lh->lh_finish))
			printf(" %d (%04d - %04d) [NO]\n", lh->lh_parameter, lh->lh_start, lh->lh_finish);
		else
			printf(" %d (%04d - %04d) [YES]\n", lh->lh_parameter, lh->lh_start, lh->lh_finish);

		printnl(lh->lh_namelist);
		printf("\n");
	}

	for (lh = namelists; lh != NULL; lh = lh->lh_next) {
		printf("\nNAMELIST %s\n", lh->lh_listname);
		printnl(lh->lh_namelist);
		printf("\n");
	}

	for (lh = exemptions; lh != NULL; lh = lh->lh_next) {
		printf("\nEXEMPTION ", lh->lh_listname);

		switch (lh->lh_command) {
		case CMD_FREEUP:	printf("freeup"); break;
		case CMD_KILLIDLE:	printf("killidle"); break;
		case CMD_KILLMULTI:	printf("killmulti"); break;
		case CMD_KILLSESSION:	printf("killsession"); break;
		}

		if (!between(curtime, lh->lh_start, lh->lh_finish))
			printf(" (%04d - %04d) [NO]\n", lh->lh_start, lh->lh_finish);
		else
			printf(" (%04d - %04d) [YES]\n", lh->lh_start, lh->lh_finish);

		printnl(lh->lh_namelist);
		printf("\n");
	}

	for (dn = deny; dn != NULL; dn = dn->dn_next) {
		if (!between(curtime, dn->dn_start, dn->dn_finish))
			printf("\nDENY (%04d - %04d) [NO]\n", dn->dn_start, dn->dn_finish);
		else
			printf("\nDENY (%04d - %04d) [YES]\n", dn->dn_start, dn->dn_finish);

		printnl(dn->dn_users);
		printnl(dn->dn_terminals);
		printf("\n");
	}
}

printnl(nl)
register struct namelist *nl;
{
	for ( ; nl != NULL; nl = nl->nl_next)
		printf("%s ", nl->nl_name);
}
#endif DEBUG
