#ifndef lint
static char *RCSid = "$Header$";
#endif

/*
 * logoff.c - routines to log terminals off
 *
 * David A. Curry
 * Purdue University
 * Engineering Computer Network
 * October, 1986
 *
 * $Log$
 */
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <setjmp.h>
#include <signal.h>
#include <stdio.h>
#include <utmp.h>
#include <pwd.h>
#include "defs.h"

extern char *deny_msg;
extern char *freeup_msg;
extern char *killidle_msg;
extern char *killmulti_msg;
extern char *killsession_msg;

/*
 * For recovering from hung opens.
 */
jmp_buf env;

extern int nvictims;
extern int graceperiod;
extern struct victim *victims;

/*
 * warnvictims - warn victims that we're going to blow them away.
 */
warnvictims()
{
	char buf[64];
	register int i, pid;
	extern int sigalarm();

	trace("warnvictims()\n", 0, 0);

	/*
	 * Fork - child does this, parent returns.  That way if
	 * we do hang, spot is still running.
	 */
	while ((pid = fork()) < 0)
		sleep(1);

	if (pid)
		return;

	/*
	 * Child shouldn't reinitialize, so ignore SIGHUP.
	 */
	signal(SIGHUP, SIG_IGN);

	/*
	 * For each victim...
	 */
	for (i=0; i < nvictims; i++) {
		/*
		 * Return to here if we time out on the open.
		 */
		if (setjmp(env))
			continue;

		/*
		 * Construct the device name.
		 */
		sprintf(buf, "/dev/%.*s", UTLINESIZE, victims[i].vi_utmp->ut_line);

		/*
		 * We have 15 seconds to open the device and deliver
		 * our message.
		 */
		signal(SIGALRM, sigalarm);
		alarm(15);

		/*
		 * Open the device.
		 */
		if (freopen(buf, "w", stdout) == NULL)
			continue;

		/*
		 * Print the message.
		 */
		prmsg(victims[i].vi_command, victims[i].vi_parameter);
		fclose(stdout);
		alarm(0);
	}

	_exit(0);
}

/*
 * killvictims - log people off
 */
killvictims()
{
	char buf[64];
	struct stat sbuf;
	register int i, pid;
	extern int sigalarm();
	struct passwd *getpwnam();
	register struct passwd *pw;

	trace("killvictims()\n", 0, 0);

	/*
	 * For each victim...
	 */
	for (i=0; i < nvictims; i++) {
		/*
		 * A new process for each victim.  That way a hang only
		 * messes up that one kill.
		 */
		while ((pid = fork()) < 0)
			sleep(1);

		/*
		 * Child.
		 */
		if (pid == 0) {
			/*
			 * Child shouldn't reinitialize, so ignore
			 * SIGHUP.
			 */
			signal(SIGHUP, SIG_IGN);

			/*
			 * Look up the user's uid.
			 */
			if ((pw = getpwnam(victims[i].vi_name)) == NULL)
				exit(1);

			/*
			 * Construct the path to the device.
			 */
			sprintf(buf, "/dev/%.*s", UTLINESIZE, victims[i].vi_utmp->ut_line);

			/*
			 * Stat it.
			 */
			if (stat(buf, &sbuf) < 0)
				exit(1);

			/*
			 * Make sure our user still owns this terminal
			 * (i.e. that he hasn't logged off).
			 */
			if (pw->pw_uid != sbuf.st_uid)
				exit(0);

			/*
			 * We come back here if the open times out.
			 */
			if (setjmp(env))
				_exit(1);

			/*
			 * Clear our controlling tty.  This is SUPPOSED
			 * to be done in main, but syslog() insists on
			 * reopening /dev/console if the openlog fails,
			 * which effectively screws us.
			 */
			if ((i = open("/dev/tty", O_RDWR)) >= 0)
				ioctl(i, TIOCNOTTY, 0);

			/*
			 * We have 15 seconds to log him off.
			 */
			signal(SIGALRM, sigalarm);
			alarm(15);

			/*
			 * Open the user's terminal.  This makes it our
			 * controlling tty.
			 */
			if (open(buf, O_RDWR) < 0)
				_exit(1);

			/*
			 * Waste him.
			 */
			vhangup();
			_exit(0);
		}
	}
}

/*
 * prmsg - print the message on the user's terminal.
 */
prmsg(cmd, parameter)
char cmd;
int parameter;
{
	register char *s;

	/*
	 * Figure out which message we want.
	 */
	switch (cmd) {
	case CMD_DENY:
		s = deny_msg;
		break;
	case CMD_FREEUP:
		s = freeup_msg;
		break;
	case CMD_KILLIDLE:
		s = killidle_msg;
		break;
	case CMD_KILLMULTI:
		s = killmulti_msg;
		break;
	case CMD_KILLSESSION:
		s = killsession_msg;
		break;
	default:
		s = NULL;
		break;
	}

	/*
	 * Start the message.
	 */
	printf("\007\007\007\r\n");
	printf("**************** SYSTEM MESSAGE ****************\r\n");

	/*
	 * Print the type-specific message.  They get the parameter
	 * if they want it.
	 */
	if (s != NULL)
		printf(s, parameter);

	/*
	 * Print the warning about logging off.
	 */
	printf("\r\n\r\n");
	printf("You have %d minutes to save your files and log off.\r\n", graceperiod);
	printf("After this time, the system will log you off automatically.\r\n");
	printf("************************************************\r\n");
}

/*
 * sigalarm - timeout routine.
 */
sigalarm()
{
	longjmp(env, 1);
}
