/*
 *
 * secpw.c
 *
 * Change passwords for the sec password file
 *
 * Usage: secpw [username]
 *
 * It may seem odd that users are allowed to change other people's
 * passwords, and change their own without supplying the old password,
 * but whoever runs this must already have a uid of root, so it
 * really doesn't matter.
 *
 */

#include <stdio.h>
#include <strings.h>
#include <sys/file.h>
#include "config.h"

extern long random();
extern char *getlogin();
extern long time();

char charset[]="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789./";

char getline(file,s)
FILE *file;
char *s;
{
  while(((*s=getc(file))!=EOF) && (*s!='\n')) s++;
  if ((*s)==EOF) return 1;
  *s=0;
  return 0;
}

main(argc,argv)
int argc;
char **argv;
{

  char key[9],salt[3],line[80],line2[80],*who,ok=0;
  FILE *f1,*f2;

  if (setuid(0))
  {
    printf("Must be root.\n");
    exit(1);
  }

  who=getlogin();
  if (argc>1)
    who=*(argv+1);

  strcpy(key,getpass("New Password:"));
  if (strcmp(key,getpass("Again:")))
  {
    printf("No Match.\n");
    exit(1);
  }

  srandom((int) time(0L));
  salt[0]=charset[random()%strlen(charset)];
  salt[1]=charset[random()%strlen(charset)];
  strcpy(line,who);
  strcat(line,":");
  strcat(line,crypt(key,salt));

  umask(0377);
  f1=fopen(FILENAME,"r");
  f2=fopen(TEMPNAME,"w");
  flock(fileno(f2),LOCK_EX);
  while(!getline(f1,line2))
    if (strncmp(line2,who,strlen(who)))
      fprintf(f2,"%s\n",line2);
    else
    {
      fprintf(f2,"%s\n",line);
      ok++;
    }
  fclose(f1);
  fclose(f2);
  rename(TEMPNAME,FILENAME);

  if (!ok)
  {
    printf("Cannot change: User not authorized.\n");
    exit(1);
  }
  
}
