#include <sys/param.h>
#include <sys/sysmacros.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/inode.h>
#include <sys/page.h>
#include <sys/seg.h>
#include <sys/proc.h>
#include <sys/text.h>
#include <sys/mount.h>
#include <sys/var.h>
#include <a.out.h>
#include "crash.h"

prvars ()
{
	printf        ("buffers	  %3d\n",
		v.v_buf);
	printf        ("calls	  %3d\n",
		v.v_call);
	printf        ("inodes	  %3d\n",
		v.v_inode);
	printf        ("e_inodes  %3d\n",
		v.ve_inode - (struct inode *) namelist[NM_INODE].xl_value);
	printf        ("files	  %3d\n",
		v.v_file);
	printf        ("e_files	  %3d\n",
		v.ve_file - (struct file *) namelist[NM_FILE].xl_value);
	printf        ("mounts	  %3d\n",
		v.v_mount);
	printf        ("e_mounts  %3d\n",
		v.ve_mount - (struct mount *) namelist[NM_MOUNT].xl_value);
	printf        ("procs	  %3d\n",
		v.v_proc);
	printf        ("e_procs	  %3d\n",
		v.ve_proc - (struct proc *) namelist[NM_PROC].xl_value);
	printf        ("texts	  %3d\n",
		v.v_text);
	printf        ("e_texts	  %3d\n",
		v.ve_text - (struct text *) namelist[NM_TEXT].xl_value);
	printf        ("clists	  %3d\n",
		v.v_clist);
	printf        ("sabufs	  %3d\n",
		v.v_sabuf);
	printf        ("maxproc	  %3d\n",
		v.v_maxup);
/*
swapmap	  105
*/
	printf        ("hashbuf	  %3d\n",
		v.v_hbuf);
	printf        ("hashmask  %3d\n",
		v.v_hmask);
}
