#include <sys/param.h>
#include <sys/sysmacros.h>
#include <sys/types.h>
#include <sys/page.h>
#include <sys/seg.h>
#include <sys/file.h>
#include <sys/proc.h>
#include <sys/signal.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/var.h>
#include <sys/lock.h>
#include "crash.h"

findu (proc, slot, user)
struct	proc	*proc;
int	slot;
struct	user	*user;
{
	struct	proc	*procs = (struct proc *) namelist[NM_PROC].xl_value;
	long	swapaddr;
	int	i;

	if ((proc->p_flag & (SSWAP|SSPART)) || ! (proc->p_flag & SLOAD)) {
		swapaddr = proc->p_addr[0].te_frameno * NBPC;
		l_lseek (swapfd, swapaddr, 0);
		r_read (swapfd, user, sizeof *user);
	} else {
		l_lseek (memfd, proc->p_addr[0].te_frameno * NBPC, 0);
		r_read (memfd, user, sizeof *user);
	}
	if (user->u_procp - procs == slot)
		return (1);
	else
		return (0);
}

prusers (items, cnt)
int	*items;
int	cnt;
{
	int	i;

	if (cnt == 0) {
		douser (-1);
		return (1);
	}
	for (i = 0;i < cnt;i++) {
		if (items[i] >= v.v_proc) {
			printf ("value (%d) out of range\n", items[i]);
			continue;
		} else {
			douser (items[i]);
		}
	}
}

douser (i)
{
	struct	file	*fp;
	struct	proc	proc;
	struct	proc	*pp;
	static	char	*segments[] = { "user", "system", "user i" };
	int	fileno;

	pp = (struct proc *) namelist[NM_PROC].xl_value;
	fp = (struct file *) namelist[NM_FILE].xl_value;

	if (i >= 0) {
		l_lseek (kmemfd, (long) &pp[i], 0);
		r_read (kmemfd, &proc, sizeof proc);

		if (! findu (&proc, i, &user))
			return (0);
	} else {
		l_lseek (kmemfd, namelist[NM_USER].xl_value, 0);
		r_read (kmemfd, &user, sizeof user);
	}
	printf ("PER PROCESS USER AREA:\n");
	printf ("USER ID's:	uid: %d, gid: %d, real uid: %d, real gid: %d\n",
		user.u_uid, user.u_gid, user.u_ruid, user.u_rgid);
	printf ("PROCESS TIMES:	user: %d, sys: %d, child user: %d, child sys: %d\n",
		user.u_utime, user.u_stime, user.u_cutime, user.u_cstime);
	printf ("PROCESS MISC:	proc slot: %d, cntrl tty: maj(%d) min(%d)\n",
		user.u_procp - pp, major (user.u_ttyd), minor (user.u_ttyd));
	printf ("IPC:		locks:%s%s%s%s%s\n",
		user.u_lock == UNLOCK ? " unlocked":"",
		user.u_lock & PROCLOCK ? " proc":"",
		user.u_lock & TXTLOCK ? " text":"",
		user.u_lock & DATLOCK ? " data":"",
		user.u_lock & HUGELOCK ? " huge":"");
	printf ("FILE I/O:	user addr: %ld, file offset: %ld, bytes: %ld,\n",
		user.u_baseu, user.u_offset, user.u_count);
	printf ("		segment: %s, umask: %01o, ulimit: %ld\n",
		segments[user.u_segflg], user.u_cmask, user.u_limit);
	printf ("ACCOUNTING:	command: %s, memory: %ld, type: %s\n",
		user.u_comm, user.u_mem, user.u_acflag ? "fork":"exec");
	printf ("		start: %s",
		ctime (&user.u_start));

	printf ("OPEN FILES:	file desc:  ");
	for (i = 0;i < NOFILE;i++)
		if (user.u_ofile[i] != (struct file *) 0)
			printf ("%4d", i);
	putchar ('\n');
	
	printf ("		file slot:  ");
	for (i = 0;i < NOFILE;i++)
		if (user.u_ofile[i] != (struct file *) 0)
			printf ("%4d", user.u_ofile[i] - fp);
	putchar ('\n');

	return (0);
}
