#include <sys/param.h>
#include <sys/sysmacros.h>
#include <sys/types.h>
#include <sys/var.h>
#include <sys/inode.h>
#include <sys/text.h>
#include <sys/page.h>
#include <sys/seg.h>
#include <sys/proc.h>
#include <a.out.h>
#include "crash.h"

prtexts (items, cnt)
int	*items;
int	cnt;
{
	int	i;

	texts = (struct text *) malloc (v.v_text * sizeof (struct text));
	lseek (kmemfd, namelist[NM_TEXT].xl_value, 0);
	read (kmemfd, texts, sizeof (struct text) * v.v_text);

	printf ("SLOT  INODE  REF  LDREF  PROC  SWAPLO+   SIZE  FLAGS\n");

	if (cnt == 0) {
		for (i = 0;i < v.v_text;i++) {
			if (texts[i].x_count == 0)
				continue;

			dotext (i);
		}
	} else {
		for (i = 0;i < cnt;i++) {
			if (items[i] >= v.v_text)
				printf ("value (%d) out of range\n", items[i]);
			else
				dotext (items[i]);
		}
	}
	free ((char *) texts);
}

dotext (i)
int	i;
{
	struct	text	*tp;
	int	procnum;

	tp = &texts[i];

	if (tp->x_ccount > 0)
		procnum = tp->x_caddr -
			(struct proc *) namelist[NM_PROC].xl_value;
	else
		procnum = 0;

	printf ("%4d  %5d  %3d  %5d  %4d  %7d  %5d ", i,
		tp->x_iptr - (struct inode *) namelist[NM_INODE].xl_value,
		tp->x_count, tp->x_ccount, procnum,
		tp->x_daddr, tp->x_size);

	if (tp->x_flag & XTRC)		printf (" trace");
	if (tp->x_flag & XWRIT)		printf (" write");
	if (tp->x_flag & XLOAD)		printf (" loaded");
	if (tp->x_flag & XLOCK)		printf (" locked");
	if (tp->x_flag & XWANT)		printf (" wanted");
	if (tp->x_flag & XLARGE)	printf (" large");
	if (tp->x_flag & XFPU)		printf (" fpu");

	printf ("\n");
}
