#include <sys/param.h>
#include <sys/sysmacros.h>
#include <sys/types.h>
#include <sys/var.h>
#include <sys/inode.h>
#include <sys/ino.h>
#include <sys/buf.h>
#include <sys/filsys.h>
#include <sys/mount.h>
#include <a.out.h>
#include "crash.h"

prmounts (items, cnt)
int	*items;
int	cnt;
{
	int	i;

	mounts = (struct mount *) malloc (v.v_mount * sizeof (struct mount));
	l_lseek (kmemfd, namelist[NM_MOUNT].xl_value, 0);
	r_read (kmemfd, mounts, sizeof (struct mount) * v.v_mount);
	l_lseek (kmemfd, namelist[NM_BUFFER].xl_value, 0);
	r_read (kmemfd, &bufstart, sizeof bufstart);

	printf ("SLOT  MAJ  MIN  INODE  BUF  VOLUME  PACK   BLOCKS INODES  BFREE  IFREE\n");

	if (cnt == 0) {
		for (i = 0;i < v.v_mount;i++) {
			if (mounts[i].m_flags == 0)
				continue;

			domount (i);
		}
	} else {
		for (i = 0;i < cnt;i++) {
			if (items[i] >= v.v_mount)
				printf ("value (%d) out of range\n", items[i]);
			else
				domount (items[i]);
		}
	}
	free ((char *) mounts);
}

domount (i)
int	i;
{
	struct	filsys	filsys;
	struct	buf	buf;
	struct	inode	*ip = (struct inode *) namelist[NM_INODE].xl_value;

	printf ("%4d %4o  %03o %6d %4d",
		i, major (mounts[i].m_dev), minor (mounts[i].m_dev),
		mounts[i].m_inodp ?
			mounts[i].m_inodp - ip : 0,
		mounts[i].m_bufp ?
			mounts[i].m_bufp - bufstart : 0);

	/*
	 * zero before using since unused mount entries don't have
	 * buffers and such.
	 */

	memset (&buf, 0, sizeof buf);
	memset (&filsys, 0, sizeof filsys);

	if (mounts[i].m_flags != 0) {
		l_lseek (memfd, (long) mounts[i].m_bufp, 0);
		r_read (memfd, &buf, sizeof buf);
		l_lseek (memfd, (long) buf.b_paddr, 0);
		r_read (memfd, &filsys, sizeof filsys);
	}
	printf ("  %-6.6s  %-6.6s",
		filsys.s_fname, filsys.s_fpack);

	printf (" %6ld %6ld %6ld %6ld",
		filsys.s_fsize, INOPB * filsys.s_isize,
		(long) filsys.s_tfree, (long) filsys.s_tinode);

	putchar ('\n');
}
