#include <sys/param.h>
#include <sys/sysmacros.h>
#include <sys/types.h>
#include <sys/var.h>
#include <sys/inode.h>
#include <a.out.h>
#include "crash.h"

prinodes (items, cnt)
int	*items;
int	cnt;
{
	int	i;

	inodes = (struct inode *) malloc (v.v_inode * sizeof (struct inode));
	l_lseek (kmemfd, namelist[NM_INODE].xl_value, 0);
	r_read (kmemfd, inodes, sizeof (struct inode) * v.v_inode);

	printf ("SLOT MAJ  MIN INUMB REF LINK  UID  GID     SIZE    MODE SMAJ SMIN FLAGS\n");

	if (cnt == 0) {
		for (i = 0;i < v.v_inode;i++) {
			if (inodes[i].i_count == 0)
				continue;

			doinode (i);
		}
	} else {
		for (i = 0;i < cnt;i++) {
			if (items[i] >= v.v_inode)
				printf ("value (%d) out of range\n", items[i]);
			else
				doinode (items[i]);
		}
	}
	free ((char *) inodes);
}
	
doinode (i)
int	i;
{
	char	*modes = " pcCd bBf";
	struct	inode	*ip;

	ip = &inodes[i];

	printf ("%4d %03o %04o %5d %3d %4d%5d%5d %8ld %c%c%c%c%03o",
		i, major (ip->i_dev), minor (ip->i_dev), ip->i_number,
		ip->i_count, ip->i_nlink, ip->i_uid, ip->i_gid,
		ip->i_size,
		modes[(ip->i_mode & IFMT) >> 12],
		(ip->i_mode & ISUID) ? 'u':'-',
		(ip->i_mode & ISGID) ? 'g':'-',
		(ip->i_mode & ISVTX) ? 't':'-',
		(ip->i_mode & 0777));

	if (! (((ip->i_mode & IFMT) == IFDIR) ||
		((ip->i_mode & IFMT) == IFREG) ||
		((ip->i_mode & IFMT) == IFIFO)))
		printf (" %04o %04o", major (ip->i_rdev),
					minor (ip->i_rdev));
	else
		printf ("    -    -");	/* special file stuff */
	if (ip->i_flag & IUPD)		printf (" upd");
	if (ip->i_flag & IACC)		printf (" acc");
	if (ip->i_flag & ICHG)		printf (" chg");
	if (ip->i_flag & IMOUNT)	printf (" mnt");
	if (ip->i_flag & ITEXT)		printf (" txt");
	if (ip->i_flag & ILOCK)		printf (" lck");
#ifdef	ISYN
	if (ip->i_flag & ISYN)		printf (" syn");
#endif
#ifdef	IRMT
	if (ip->i_flag & IRMT)		printf (" rmt");
#endif
	if (ip->i_flag & IWANT)		printf (" wnt");

	printf ("\n");
}
