#include <sys/param.h>
#include <sys/sysmacros.h>
#include <sys/types.h>
#include <sys/var.h>
#include <sys/inode.h>
#include <sys/file.h>
#include <sys/page.h>
#include <sys/seg.h>
#include <sys/signal.h>
#include <sys/dir.h>
#include <sys/user.h>
#include "crash.h"

prfiles (items, cnt)
int	*items;
int	cnt;
{
	int	i;

	files = (struct file *) malloc (v.v_file * sizeof (struct file));
	l_lseek (kmemfd, namelist[NM_FILE].xl_value, 0);
	r_read (kmemfd, files, sizeof (struct file) * v.v_file);

	printf ("SLOT    FLAG          COUNT  INODE      OFFSET\n");
	if (cnt == 0) {
		for (i = 0;i < v.v_file;i++) {
			if (files[i].f_count == 0 || files[i].f_flag == 0)
				continue;

			dofile (i);
		}
	} else {
		for (i = 0;i < cnt;i++) {
			if (items[i] >= v.v_file)
				printf ("value (%d) out of range\n", items[i]);
			else
				dofile (items[i]);
		}
	}
	free ((char *) files);
}


dofile (i)
int	i;
{
	printf ("%4d    %03o %c%c%c%c%c%c%c%c  %5d  %5d  %10ld\n",
		i, files[i].f_flag & FMASK,
		(files[i].f_flag & FREAD) ? 'R':' ',
		(files[i].f_flag & FWRITE) ? 'W':' ',
		(files[i].f_flag & FNDELAY) ? 'N':' ',
		(files[i].f_flag & FAPPEND) ? 'A':' ',
		(files[i].f_flag & FSYNC) ? 'S':' ',
		(files[i].f_flag & FCREAT) ? 'C':' ',
		(files[i].f_flag & FTRUNC) ? 'T':' ',
		(files[i].f_flag & FEXCL) ? 'X':' ',
		files[i].f_count,
		files[i].f_inode - (struct inode *) namelist[NM_INODE].xl_value,
		files[i].f_offset);
}
