#include <sys/param.h>
#include <sys/sysmacros.h>
#include <sys/types.h>
#include <sys/var.h>
#include <sys/inode.h>
#include <sys/ino.h>
#include <sys/buf.h>
#include <a.out.h>
#include "crash.h"

prbufs (items, cnt)
int	*items;
int	cnt;
{
	int	i;

	bufs = (struct buf *) malloc (v.v_buf * sizeof (struct buf));

	l_lseek (kmemfd, namelist[NM_BUFFER].xl_value, 0);
	r_read (kmemfd, &bufstart, sizeof bufstart);

	l_lseek (memfd, bufstart, 0);
	r_read (memfd, bufs, v.v_buf * sizeof (struct buf));

	printf (" BUF MAJ  MIN    BLOCK FLAGS\n");

	if (cnt == 0) {
		for (i = 0;i < v.v_buf;i++) {
			if (bufs[i].b_flags == 0)
				continue;

			dobuf (i);
		}
	} else {
		for (i = 0;i < cnt;i++) {
			if (items[i] >= v.v_buf)
				printf ("value (%d) out of range\n", items[i]);
			else
				dobuf (items[i]);
		}
	}
	free ((char *) bufs);
}

dobuf (i)
int	i;
{
	struct	buf	*bp;

	bp = &bufs[i];

	printf ("%4d %03.3o %04.4o %8d",
		i, major (bp->b_dev) & 0377, minor (bp->b_dev), bp->b_blkno);

	if (bp->b_flags & B_READ)	printf (" read");
	if (bp->b_flags & B_DONE)	printf (" done");
	if (bp->b_flags & B_ERROR)	printf (" error");
	if (bp->b_flags & B_BUSY)	printf (" busy");
	if (bp->b_flags & B_PHYS)	printf (" phys");
	if (bp->b_flags & B_MAP)	printf (" map");
	if (bp->b_flags & B_WANTED)	printf (" wanted");
	if (bp->b_flags & B_AGE)	printf (" age");
	if (bp->b_flags & B_ASYNC)	printf (" async");
	if (bp->b_flags & B_DELWRI)	printf (" delwri");
	if (bp->b_flags & B_OPEN)	printf (" open");
	if (bp->b_flags & B_STALE)	printf (" stale");
	if (bp->b_flags & B_NOCROSS)	printf (" nocross");
	if (bp->b_flags & B_FLUSH)	printf (" flush");

	putchar ('\n');
}
