#include <sys/param.h>
#include <sys/sysmacros.h>
#include <sys/types.h>
#include <sys/utsname.h>
#include <sys/param.h>
#include <a.out.h>
#include <time.h>
#include "crash.h"

#define	MINUTE	(60L)
#define	HOUR	(MINUTE*60L)
#define	DAY	(HOUR*24L)

prstats ()
{
	l_lseek (kmemfd, namelist[NM_UTSNAME].xl_value, 0);
	r_read (kmemfd, &utsname, sizeof utsname);

	l_lseek (kmemfd, namelist[NM_TIME].xl_value, 0);
	r_read (kmemfd, &ktime, sizeof ktime);

	l_lseek (kmemfd, namelist[NM_LBOLT].xl_value, 0);
	r_read (kmemfd, &klbolt, sizeof klbolt);

	printf ("	sysname: %.*s\n",
		sizeof utsname.sysname, utsname.sysname);
	printf ("	nodename: %.*s\n",
		sizeof utsname.nodename, utsname.nodename);
	printf ("	release: %.*s\n",
		sizeof utsname.release, utsname.release);
	printf ("	version: %.*s\n",
		sizeof utsname.version, utsname.version);
	printf ("	machine: %.*s\n",
		sizeof utsname.machine, utsname.machine);

	printf ("	time of crash: %s", ctime (&ktime));

	klbolt /= HZ;			/* convert to seconds */

	printf ("	age of system:");

	if (klbolt >= DAY)
		printf (" %d %s,", klbolt / DAY,
			klbolt >= (2*DAY) ? "days":"day");

	klbolt %= DAY;

	if (klbolt >= HOUR)
		printf (" %d %s,", klbolt / HOUR,
			klbolt >= (2*HOUR) ? "hrs.":"hr.");

	klbolt %= HOUR;
	klbolt /= MINUTE;

	printf (" %d %s\n", klbolt,
		klbolt == 0 || klbolt >= 2 ? "mins.":"min.");
}
