#include <sys/param.h>
#include <sys/sysmacros.h>
#include <sys/types.h>
#include <sys/var.h>
#include <sys/text.h>
#include <sys/page.h>
#include <sys/seg.h>
#include <sys/proc.h>
#include <sys/signal.h>
#include <sys/dir.h>
#include <sys/user.h>
#include "crash.h"

/*
 * prprocs - output the process table
 */

prprocs (items, cnt)
int	*items;
int	cnt;
{
	struct	proc	*pp;
	struct	user	user;
	int	i;

	procs = (struct proc *) malloc (v.v_proc * sizeof (struct proc));
	lseek (kmemfd, namelist[NM_PROC].xl_value, 0);
	read (kmemfd, procs, sizeof (struct proc) * v.v_proc);

	printf ("SLT ST  PID  PPID  PGRP   UID  EUID PRI CPU    EVENT NAME       FLAGS\n");

	if (cnt == 0) {
		for (i = 0;i < v.v_proc;i++) {
			if (procs[i].p_stat == 0)
				continue;

			doproc (i);
		}
	} else {
		for (i = 0;i < cnt;i++) {
			if (items[i] >= v.v_proc)
				printf ("value (%d) out of range\n", items[i]);
			else
				doproc (items[i]);
		}
	}
	free ((char *) procs);
}

doproc (i)
int	i;
{
	struct	proc	*pp;

	pp = &procs[i];

	printf ("%3d %c %5d %5d %5d %5d %5d %3d %3d", i,
		" swriztBST"[pp->p_stat], pp->p_pid, pp->p_ppid,
		pp->p_pgrp, pp->p_uid, pp->p_suid,
		pp->p_pri & 0377, pp->p_cpu & 0377);

	if (pp->p_wchan)
		printf (" %8x", pp->p_wchan);
	else
		printf ("         ");

	if (pp->p_stat == SZOMB) {
		printf (" ZOMBIE    ");
	} else if (pp->p_flag & SSYS) {
		printf (" swapper   ");
	} else if (pp->p_stat != 0) {
		if (findu (pp, i, &user))
			printf (" %-10.10s", user.u_comm);
		else
			printf (" SWAPPED   ");
	} else {
		printf ("           ");
	}
	if (pp->p_stat == SRUN)		printf (" running");
	if (pp->p_stat == SZOMB)	printf (" zombie");
	if (pp->p_flag & SLOAD)		printf (" incore");
	else				printf (" swapped");
	if (pp->p_flag & SSYS)		printf (" sched");
	if (pp->p_flag & SLOCK)		printf (" locked");
	if (pp->p_flag & STRC)		printf (" traced");
	if (pp->p_flag & SWTED)		printf (" wanted");
	if (pp->p_flag & STEXT)		printf (" text");
	if (pp->p_flag & SSPART)	printf (" part-swap");

	printf ("\n");
}
