#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <setjmp.h>
#include <signal.h>

extern	prbufs ();
extern	prfiles ();
extern	prinodes ();
extern	prmounts ();
extern	prprocs ();
extern	prstats ();
extern	prtexts ();
extern	prusers ();
extern	prvars ();
extern	quit ();
extern	help ();
extern	int	errno;

jmp_buf	del;
int	delflag;

struct	func {
	void	(*f_func)();
	char	*f_name;
};

struct	func	commands[] = {
	{ prbufs, "b" },
	{ prbufs, "buf" },
	{ prfiles, "f" },
	{ prfiles, "file" },
	{ help, "h" },
	{ help, "help" },
	{ prinodes, "i" },
	{ prinodes, "ino" },
	{ prinodes, "inode" },
	{ prmounts, "m" },
	{ prmounts, "mount" },
	{ prprocs, "p" },
	{ prprocs, "proc" },
	{ quit, "q" },
	{ quit, "quit" },
	{ prstats, "s" },
	{ prstats, "stat" },
	{ prtexts, "t" },
	{ prtexts, "text" },
	{ prusers, "u" },
	{ prusers, "user" },
	{ prvars, "v" },
	{ prvars, "var" },
	{ 0, 0 }
};

help ()
{
	printf ("command summary\n\n");

	printf ("buf (b)        - buffer headers\n");
	printf ("file (f)       - open files\n");
	printf ("help (h,?)     - list commands\n");
	printf ("inode (ino,i)  - active inodes\n");
	printf ("mount (m)      - mounted file systems\n");
	printf ("proc (p)       - active and defunct processes\n");
	printf ("quit (q,^D)    - exit crash\n");
	printf ("stat (s)       - crash statistics, age, time\n");
	printf ("text (t)       - active and sticky bit text segments\n");
	printf ("user (u)       - user page information\n");
	printf ("var (v)        - tunable parameters\n");
}

quit ()
{
	exit (0);
}

interupt (sig)
int	sig;
{
	delflag = 1;
	fflush (stdout);
	fflush (stderr);
	longjmp (del, sig);
}

interact ()
{
	int	i;
	int	items[100];
	int	cnt;
	char	*cp;
	char	*com;
	char	*num;
	char	buf[BUFSIZ];

	while (setjmp (del))		/* catch that first interupt */
		fprintf (stderr, "\nq to quit\n");

	signal (SIGINT, interupt);	/* and setup the handler */

	while (fprintf (stderr, "> "), gets (buf) != (char *) 0) {
		while (setjmp (del))
			goto eh;

		/*
		 * make all commands lower case.
		 */

		for (i = strlen (buf) - 1;i >= 0;i--)
			if (isupper (buf[i]))
				buf[i] = tolower (buf[i]);

		/*
		 * find first non-white space character and skip if
		 * a blank line
		 */

		for (com = buf;*com && (*com == ' ' || *com == '\t');com++)
			;

		if (*com == '\0')
			continue;

		/*
		 * find the entire command word
		 */

		if (*com == '?') {
			help ();
			continue;
		}

		for (cp = com;*cp >= 'a' && *cp <= 'z';cp++)
			;

		if (*cp != '\0') {
			*cp++ = '\0';

		/*
		 * tokenize the remainder of the string into numbers
		 */

			for (cnt = 0;*cp && cnt < 100;cnt++) {
				for (;*cp && isspace (*cp);cp++)
					;

				for (num = cp;*cp && isdigit (*cp);cp++)
					;

				if (*cp && ! isspace (*cp))
					goto eh;

				if (*cp)
					*cp++ = '\0';

				items[cnt] = atoi (num);
			}
		} else {
			cnt = 0;
		}
		
		for (i = 0;commands[i].f_name != (char *) 0;i++)
			if (strcmp (commands[i].f_name, com) == 0)
				break;

		if (commands[i].f_name == (char *) 0)
			goto eh;

		(*commands[i].f_func) (items, cnt);
		continue;

		/*
		 * common error handler.  get here if an error is found.
		 */
eh:
		if (delflag) {
			putc ('\n', stderr);
			delflag = 0;
		}
		fprintf (stderr, "eh?\n");
		signal (SIGINT, interupt);
	}
}
