#include <sys/param.h>
#include <sys/sysmacros.h>
#include <sys/types.h>
#include <sys/page.h>
#include <sys/seg.h>
#include <sys/proc.h>
#include <sys/signal.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/var.h>
#include <sys/utsname.h>
#include <fcntl.h>
#include <stdio.h>
#include "crash.h"

int	memfd;
int	kmemfd;
int	swapfd;

int	bflag;
int	fflag;
int	iflag;
int	mflag;
int	pflag;
int	sflag;
int	tflag;
int	uflag;
int	vflag;

int	anyflag;

struct	var	v;
struct	file	*files;
struct	inode	*inodes;
struct	text	*texts;
struct	proc	*procs;
struct	mount	*mounts;
struct	buf	*bufs;
struct	buf	*bufstart;
struct	user	user;
daddr_t	swplo;
struct	utsname	utsname;
time_t	ktime;
time_t	klbolt;

struct	xlist	namelist[] = {
	{ 0, 0, 0, "_v" },
	{ 0, 0, 0, "_file" },
	{ 0, 0, 0, "_inode" },
	{ 0, 0, 0, "_proc" },
	{ 0, 0, 0, "_text" },
	{ 0, 0, 0, "_mount" },
	{ 0, 0, 0, "_bufstrt" },
	{ 0, 0, 0, "_swplo" },
	{ 0, 0, 0, "_time" },
	{ 0, 0, 0, "_lbolt" },
	{ 0, 0, 0, "_utsname" },
	{ 0, 0, 0, "_u" },
	{ 0, 0, 0, (char *) 0 }
};

usage ()
{
	fprintf (stderr, "usage: crash -bfimpstv [ -N namelist ] ");
	fprintf (stderr, "[ -C corefile ] [ -S swapfile ]\n");
	exit (1);
}

r_read (fd, buf, n)
int	fd;
char	*buf;
int	n;
{
	int	i;

	if ((i = read (fd, buf, n)) == -1) {
		perror ("error on read");
		return (-1);
	} else
		return (i);
}

long	l_lseek (fd, offs, whence)
int	fd;
long	offs;
int	whence;
{
	long	i;
	long	lseek ();

	if ((i = lseek (fd, offs, whence)) == -1L) {
		perror ("error on lseek");
		return (-1);
	} else
		return (i);
}

main (argc, argv)
int	argc;
char	**argv;
{
	char	newname[10];
	char	*namefile = "/xenix";
	char	*corefile = "/dev/mem";
	char	*kmemfile = "/dev/kmem";
	char	*swapfile = "/dev/swap";
	int	c;
	extern	int	optind;
	extern	char	*optarg;

	setbuf (stdout, NULL);
	setbuf (stderr, NULL);

	while ((c = getopt (argc, argv, "bfimpstuvN:C:S:")) != EOF) {
		switch (c) {
			case 'b':
				bflag++;
				anyflag++;
				break;
			case 'C':
				corefile = optarg;
				kmemfile = optarg;
				break;
			case 'f':
				fflag++;
				anyflag++;
				break;
			case 'i':
				iflag++;
				anyflag++;
				break;
			case 'm':
				mflag++;
				anyflag++;
				break;
			case 'N':
				namefile = optarg;
				break;
			case 'p':
				pflag++;
				anyflag++;
				break;
			case 's':
				sflag++;
				anyflag++;
				break;
			case 'S':
				swapfile = optarg;
				break;
			case 't':
				tflag++;
				anyflag++;
				break;
			case 'u':
				uflag++;
				anyflag++;
				break;
			case 'v':
				vflag++;
				anyflag++;
				break;
			default:
				usage ();
		}
	}
	if (xlist (namefile, namelist) != 0) {
		perror ("pstat: namelist");
		exit (1);
	}
	if ((memfd = open (corefile, O_RDONLY)) < 0) {
		perror ("pstat: corefile");
		exit (1);
	}
	if ((kmemfd = open (kmemfile, O_RDONLY)) < 0) {
		perror ("pstat: kmemfile");
		exit (1);
	}
	if ((swapfd = open (swapfile, O_RDONLY)) < 0) {
		perror ("pstat: swapfile");
		exit (1);
	}
	l_lseek (kmemfd, namelist[NM_V].xl_value, 0);
	r_read (kmemfd, &v, sizeof v);
	l_lseek (kmemfd, namelist[NM_SWPLO].xl_value, 0);
	r_read (kmemfd, &swplo, sizeof swplo);

	if (bflag)
		prbufs ((int *) 0, 0);

	if (fflag)
		prfiles ((int *) 0, 0);

	if (iflag)
		prinodes ((int *) 0, 0);

	if (mflag) 
		prmounts ((int *) 0, 0);

	if (pflag)
		prprocs ((int *) 0, 0);

	if (sflag)
		prstats ((int *) 0, 0);

	if (tflag)
		prtexts ((int *) 0, 0);

	if (uflag)
		prusers ((int *) 0, 0);

	if (vflag)
		prvars ((int *) 0, 0);

	if (! anyflag) {
		interact ();
		exit (0);
	} else {
		exit (0);
	}
}
