/*
 * loadd -- accept UDP load status requests, and return fixed-point
 * indication of current load averages.
 *
 * Steven D. Miller (steve@maryland.ARPA)
 *
 */

#include <nlist.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <syslog.h>
#include "rload.h"
#define fixify(a)	((long) ((a) * 256.0))

int	kmem;
long	umph = 1;	/*
			 * current cpu power factor; 1/256 if unknown
			 */

main()
{
    struct  rload r_load;
    struct  sockaddr_in laddr, faddr;
    struct  servent *serv;
    int	skt, fsize = sizeof(faddr);
    int getumph();
    char    c;

#ifndef DEBUG
    if (fork())
	exit (0);
    { int s;
      for (s = 0; s < 10; s++)
	  (void) close(s);
      (void) open("/", 0);
      (void) dup2(0, 1);
      (void) dup2(0, 2);
      s = open("/dev/tty", 2);
      if (s >= 0) {
	  (void) ioctl(s, TIOCNOTTY, (char *)0);
	  (void) close(s);
      }
    }
#endif
    (void) signal(SIGHUP, getumph);	/* reconfigure on HUP */
    serv = getservbyname("load", "udp");
    if (serv == NULL) {
#ifdef DEBUG
	fprintf(stderr,"loadd: load/udp: unknown service\n");
#else
	syslog(LOG_ERR,"loadd: load/udp: unknown service\n");
#endif
	exit (1);
    }
    skt = socket(AF_INET, SOCK_DGRAM, 0);
    if (skt < 0) {
#ifdef DEBUG
	perror("loadd: socket");
#else
	syslog(LOG_ERR, "loadd: couldn't get socket (%m)");
#endif
	exit (1);
    }
    laddr.sin_family = AF_INET;
    laddr.sin_port = serv->s_port;
    laddr.sin_addr.s_addr = 0;	/* for grins */
    if (bind (skt, &laddr, sizeof (laddr)) < 0) {
#ifdef DEBUG
	perror("loadd: bind");
#else
	syslog(LOG_ERR, "loadd: bind (%m)");
#endif
	(void) close (skt);
	exit (1);
    }
    getumph();
    kmem = open("/dev/kmem", 0);
    if (kmem < 0) {
#ifdef DEBUG
	perror("loadd: open /dev/kmem");
#else
	syslog(LOG_ERR, "loadd: open /dev/kmem (%m)");
#endif
	(void) close (skt);
	exit (1);
    }
    for (;;) {
	if (recvfrom(skt, &c, 1, 0, (struct sockaddr *)&faddr, &fsize) != 1) {
#ifdef DEBUG
	    perror("loadd: recvfrom");
#else
	    syslog(LOG_WARNING, "loadd: recvfrom: %m");
#endif
	    continue;
	}
#ifdef DEBUG
	fprintf(stderr,"loadd: got request from %lx\n", 
	   ntohl(faddr.sin_addr.s_addr));
#endif
	loadav(&r_load);
	if (sendto(skt, (char *)&r_load, 4*sizeof(long), 0,
	    (struct sockaddr *)&faddr, sizeof(faddr)) != 4*sizeof(long)) {
#ifdef DEBUG
	    perror("loadd: sendto");
#else
	    syslog(LOG_WARNING, "loadd: sendto: %m");
#endif
	    continue;
	}
    }
}

struct nlist avenrun[] = {
    {"_avenrun"},
    0
};

loadav(avg)
    struct rload *avg;
{
#ifndef sun
    double kavg[3];
#endif
    static beenhere;
    long lseek();

    if (!beenhere) {
	beenhere++;
	nlist("/vmunix", avenrun);
    }
    if (avenrun[0].n_type == 0) {
#ifdef DEBUG
	fprintf(stderr, "loadd: can't find _avenrun\n");
#else
	syslog(LOG_WARNING, "loadd: can't find _avenrun");
#endif
	avg->avgs[0] = avg->avgs[1] = avg->avgs[2] = 0xfffe;
	return;
    }

    (void) lseek(kmem, (long) avenrun[0].n_value, 0);
	      
#ifndef sun
    if (read(kmem, (char *)kavg, 3*sizeof (double)) != 3*sizeof(double)) {
#ifdef DEBUG
	perror("loadd: bad read");
#else
	syslog(LOG_WARNING, "loadd: bad read (%m)");
#endif
	avg->avgs[0] = avg->avgs[1] = avg->avgs[2] = 0xfffe;
    }
    /*
     * If we are using floats in the kernel, let's convert
     * them to fixed-point numbers to send across the net.
     */
    avg->avgs[0] = htonl(fixify(kavg[0]));
    avg->avgs[1] = htonl(fixify(kavg[1]));
    avg->avgs[2] = htonl(fixify(kavg[2]));
#else
    /* note sun byte order == net byte order - no conversion needed */
    if (read(kmem, (char *)avg->avgs, 3*sizeof(long)) != 3*sizeof(long)) {
#ifdef DEBUG
	perror("loadd: bad read");
#else
	syslog(LOG_WARNING, "loadd: bad read (%m)");
#endif
	avg->avgs[0] = avg->avgs[1] = avg->avgs[2] = 0xfffe;
    }
#endif
    avg->cpuumph = htonl(umph);
    return;
	
}

getumph()
{
    FILE *umphfile;
    char buf[512];
    float floatumph;

    umphfile = fopen("/etc/loadd.conf", "r");
    if (umphfile == NULL) {
#ifdef DEBUG
	perror("loadd: open /etc/loadd.conf");
#else
	syslog(LOG_ERR, "loadd: open /etc/loadd.conf (%m)");
#endif
	/* note that we leave the umph at its old value, if any */
    }
    else {
	while(fgets(buf, sizeof(buf), umphfile) != NULL) {
	    if (buf[0] == '#') /* comment line */
		continue;
	    if (sscanf(buf, "localpower %f", &floatumph) < 1) {
#ifdef DEBUG
	        fprintf(stderr, "loadd: /etc/loadd.conf: bad format\n");
#else
	        syslog(LOG_ERR, "loadd: /etc/loadd.conf: bad format");
#endif
		(void) fclose(umphfile);
	        return;	/* leave umph at old value */
	    }
	umph = fixify(floatumph);
	(void) fclose(umphfile);
	}
    }
}
