#ifndef lint
static char *scssid = "@(#)load.c	(University of Maryland) Oct 7, 1981";
static char RCSid[] = "@(#)$Header: /usr/steve/rtroff/RCS/load.c,v 2.1 85/09/09 11:51:55 steve Exp $";
#endif lint

/*
 * load.c - returns true if the system load is >= value given by argv[1]
 *
 * 	Cannibalized from rogue (main.c) by Fred Blonder, Oct 7, 1981
 *
 * 	Modified by Steve Miller to work on Suns.
 */

#include <sysexits.h>
#include <nlist.h>
#include <stdio.h>

#define fixify(a)	((long) ((a) * 256.0))

main(argc, argv)
    int argc;
    char *argv[];
{
    double  maxload = 0.0, atof();
#ifdef sun
    long    avec[3];
#else
    double  avec[3];
#endif
    char   *yes_msg = "Yes\n",
           *no_msg = "No\n";

    while (argc > 2 && argv[1][0] == '-') {
	switch (argv[1][1]) {
	    case 's': 
		yes_msg = no_msg = "";
		break;

	    case 'v': 
		yes_msg = "System load too high\n";
		no_msg = "System load not too high\n";
		break;

	    default: 
		printf ("Load: option ``%s'' not recognized, ignored.\n", argv[1]);
	}
	argc--;
	argv++;
    }

    loadav (avec);

    if (argc < 2) {
#ifdef sun
	printf ("%5.2f\n", avec[0] / 256.0);
#else
	printf ("%5.2f\n", avec[0]);
#endif
	exit (EX_OK);
    }

    if ((maxload = atof (argv[1])) <= 0.0) {
	printf ("Load: absurd load value: %f\n", maxload);
	exit (EX_DATAERR);
    }

#ifdef sun
    if (avec[0] >= fixify(maxload)) {
#else
    if (avec[0] >= maxload) {
#endif
	printf (yes_msg);
	exit (EX_OK);
    }
    else {
	printf (no_msg);
	exit (1);
    }
}

struct nlist avenrun[] = {
    {"_avenrun"},
    0
};

loadav(avg)
#ifdef sun
    register long *avg;
#else
    register double *avg;
#endif
{
    register int kmem;
    int nread;

    if ((kmem = open("/dev/kmem", 0)) < 0) {
	perror("Can't open /dev/kmem");
	exit(EX_OSFILE);
    }
    nlist("/vmunix", avenrun);
    if (avenrun[0].n_type == 0) {
	fprintf(stderr, "load: can't find _avenrun\n");
#ifdef sun
	avg[0] = avg[1] = avg[2] = 0;
#else
	avg[0] = avg[1] = avg[2] = 0.0;
#endif
	return;
    }

    (void) lseek(kmem, (long) avenrun[0].n_value, 0);
#ifdef sun
    nread = read(kmem, (char *)avg, 3 * sizeof (long));
#else
    nread = read(kmem, (char *)avg, 3 * sizeof (double));
#endif
    if (nread < 0) {
	perror("load: read from kmem");
	exit(EX_IOERR);
    }
}
